/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This simple struct contains the information that we discover at
 * the time of device discovery. We can use this information to later
 * construct an {@link BEnvCtrlDevice} instance.
 *
 * @author J. Spangler
 */
public class BDeviceLearnEntry
    extends BStruct
{
  /*-
   class BDeviceLearnEntry
   {
     properties
     {
       deviceName: String
         default {[ "" ]}
         
       deviceId: int
         default {[ -1 ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.BDeviceLearnEntry(1495533858)1.0$ @*/
/* Generated Mon Mar 04 16:24:02 EST 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceName</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#getDeviceName
   * @see com.examples.envctrldriver.BDeviceLearnEntry#setDeviceName
   */
  public static final Property deviceName = newProperty(0, "",null);
  
  /**
   * Get the <code>deviceName</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#deviceName
   */
  public String getDeviceName() { return getString(deviceName); }
  
  /**
   * Set the <code>deviceName</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#deviceName
   */
  public void setDeviceName(String v) { setString(deviceName,v,null); }

////////////////////////////////////////////////////////////////
// Property "deviceId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#getDeviceId
   * @see com.examples.envctrldriver.BDeviceLearnEntry#setDeviceId
   */
  public static final Property deviceId = newProperty(0, -1,null);
  
  /**
   * Get the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#deviceId
   */
  public int getDeviceId() { return getInt(deviceId); }
  
  /**
   * Set the <code>deviceId</code> property.
   * @see com.examples.envctrldriver.BDeviceLearnEntry#deviceId
   */
  public void setDeviceId(int v) { setInt(deviceId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDeviceLearnEntry.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
