/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package com.examples.envctrldriver;

import javax.baja.job.*;
import javax.baja.sys.*;
import javax.baja.util.*;
import javax.baja.nre.util.*;

/**
 * Job for discovering devices currently on the remote EnvController network.
 *
 * @author J. Spangler
 * @creation Mar 4, 2013
 *
 */
public class BDeviceDiscoveryJob
    extends BSimpleJob
{
  /*-
   class BDeviceDiscoveryJob
   {
     properties
     {
      learnedDevices : BFolder
        -- Contains dynamic BComponent slots, each slot corresponds to
        -- the discovery information about a learned device.
        flags{hidden, readonly, transient}
        default{[new BFolder()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.examples.envctrldriver.BDeviceDiscoveryJob(3044262369)1.0$ @*/
/* Generated Mon Mar 04 15:37:18 EST 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "learnedDevices"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>learnedDevices</code> property.
   * Contains dynamic BComponent slots, each slot corresponds
   * to the discovery information about a learned device.
   * @see com.examples.envctrldriver.BDeviceDiscoveryJob#getLearnedDevices
   * @see com.examples.envctrldriver.BDeviceDiscoveryJob#setLearnedDevices
   */
  public static final Property learnedDevices = newProperty(Flags.HIDDEN|Flags.READONLY|Flags.TRANSIENT, new BFolder(),null);
  
  /**
   * Get the <code>learnedDevices</code> property.
   * Contains dynamic BComponent slots, each slot corresponds
   * to the discovery information about a learned device.
   * @see com.examples.envctrldriver.BDeviceDiscoveryJob#learnedDevices
   */
  public BFolder getLearnedDevices() { return (BFolder)get(learnedDevices); }
  
  /**
   * Set the <code>learnedDevices</code> property.
   * Contains dynamic BComponent slots, each slot corresponds
   * to the discovery information about a learned device.
   * @see com.examples.envctrldriver.BDeviceDiscoveryJob#learnedDevices
   */
  public void setLearnedDevices(BFolder v) { set(learnedDevices,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDeviceDiscoveryJob.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Framework No Arg constructor
   */
  public BDeviceDiscoveryJob()
  {
    this.network = null;
  }
  
  /**
   * Constructor 
   * 
   * @param network
   *          - {@link BEnvCtrlDeviceNetwork} network to use to send 
   *            discovery request
   */
  public BDeviceDiscoveryJob(BEnvCtrlDeviceNetwork network)
  {
    this.network = network;
  }

  /**
   * Add an entry into our BFolder that represents a discovered device.
   * This information should be enough to reconstruct our device
   * representation when we add the entry into the running station.
   * 
   * @param deviceName
   *          - String name of the device that we are adding to our
   *            list of entries as it is named on the remote network.
   * @param id
   *          - int ID of the remote device.
   */
  private void addEntry(String deviceName, int id)
  {
    BDeviceLearnEntry entry = new BDeviceLearnEntry();
    entry.setDeviceName(deviceName);
    entry.setDeviceId(id);
    getLearnedDevices().add(null,entry);
  }
  
  public void run(Context cx) throws Exception
  {
    log().message("Starting");
    
    //send a message to the network requesting discovery of all devices.
    if( null == network)
    {
      log().failed("Not connected to network");
      failed(new BajaRuntimeException("No Network found"));
    }
    
    String response = network.sendRequest("learn");
    
    //parse response into entries
    String[] deviceEntries = TextUtil.split(response, ';');
    for( int i = 0; i < deviceEntries.length; i++)
    {
      //split the device entry into name and id
      String entry = deviceEntries[i];
      String[] values = TextUtil.split(entry,' ');
      
      if( values.length < 2) continue;
      
      int id = Integer.parseInt(values[1]);
      addEntry(values[0], id);
      log().message("discovered device: " + values[0]);
    }

    success();
  }

/////////////////////////////////////////////////////////////////
//  Attributes
/////////////////////////////////////////////////////////////////
  
  BEnvCtrlDeviceNetwork network;
}
