/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/*jshint browser:true*/
/*global $*/

/**
 * Handles offline loaded content for the Workbench environment.
 */
$(function ordProcess() {
  "use strict";

  // Test whether we should hijack an anchor click
  var shouldConsumeClick = function(src, href, target) {    
    if (!src || !href) {
      return false;
    }
    // If the anchor has a bootstrap data-toggle attribute, let the browser handle it internally.
    if (src.attr("data-toggle")) {
      return false;
    }
    return !href.match(/^http/);
  };
  
  // Hijack all anchor clicks so we can possibly resolve and reload using Java code
  $(document).on("click", "a", function (e) {

    // Ignore this event if preventDefault has been called.
    if (e.defaultPrevented) {
      return;
    }
    
    var src = $(e.target).closest("a"),
        href = src.attr("href"),
        target = src.attr("target");

    if (shouldConsumeClick(src, href, target)) {   
      e.preventDefault();
      window.niagaraWbHyperlink(href, target || "");
    }
  });
});
