/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*jshint devel: true */

/**
 * API Status: **Private**
 * @module nmodule/js/rc/log/handlers/consoleHandler
 */
define(['nmodule/js/rc/log/Level'], function (Level) {
  'use strict';
  
  var ERROR_THRESHOLD = Level.WARNING;
  
  function hasConsole() { return typeof console === 'object' && console; }
  function hasLog() { return hasConsole() && typeof console.log === 'function'; }
  function hasError() { return hasConsole() && typeof console.error === 'function'; }
  
  function log() {
    return hasLog() && console.log.apply(console, arguments);
  }
  
  function error() {
    return hasError() ?
      console.error.apply(console, arguments) :
      log.apply(null, arguments);
  }
  
  /**
   * Handler to publish log messages to console.error (SEVERE/WARNING),
   * console.log otherwise. If an Error is given, it will be logged to the
   * console directly to allow stack inspection.
   * 
   * @type {module:nmodule/js/rc/log/Log~Handler}
   * @alias module:nmodule/js/rc/log/handlers/consoleHandler
   */
  return {
    publish: function (name, level, msg) {
      var err = (msg instanceof Error) && msg;
      if (level.intValue() >= ERROR_THRESHOLD.intValue()) {
        if (err) { error(err); }
        return error('[' + name + '] ' + msg);
      } else {
        if (err) { log(err); }
        return log('[' + name + '] ' + msg);
      }
    }
  };
});
