/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/js/rc/log/Level
 */
define(['underscore'], function (_) {

  'use strict';

  var HIDDEN_CONSTANT = {
      configurable: false, enumerable: false, writable: false
    },
    VISIBLE_CONSTANT = {
      configurable: false, enumerable: true, writable: false
    };

  function def(obj, name, value, props) {
    Object.defineProperty(obj, name, _.extend({value: value}, props));
  }
  
  /**
   * Describes a logging level. This constructor not to be invoked directly -
   * use one of the constants like `SEVERE` instead.
   *
   * @class
   * @memberOf module:nmodule/js/rc/log/Log
   * @param {string} name
   * @param {number} value
   */
  var Level = function Level(name, value /* TODO: i18n */) {
    def(this, 'name', name, VISIBLE_CONSTANT);
    def(this, 'value', value, HIDDEN_CONSTANT);
  };

  /**
   * @returns Level name
   */
  Level.prototype.getName = function () {
    return this.name;
  };

  /**
   * @private
   * @returns Level priority (lower numbers are for more detailed/chatty logs).
   */
  Level.prototype.intValue = function () {
    return this.value;
  };

  Level.prototype.toString = function () {
    return this.getName();
  };

  /** No logging. */
  Level.OFF = new Level('OFF', Number.MAX_VALUE);

  /** Major error condition. */
  Level.SEVERE = new Level('SEVERE', 1000);

  /** Potential problem. */
  Level.WARNING = new Level('WARNING', 900);

  /** Informational. */
  Level.INFO = new Level('INFO', 800);

  /** Configuration. */
  Level.CONFIG = new Level('CONFIG', 700);

  /** Detailed tracing info. */
  Level.FINE = new Level('FINE', 500);

  /** Highly detailed tracing info. */
  Level.FINER = new Level('FINER', 400);

  /** Ludicrously detailed tracing info. */
  Level.FINEST = new Level('FINEST', 300);

  /** All logging output. */
  Level.ALL = new Level('ALL', Number.MIN_VALUE);
  
  return Level;
});
