/**
 * A RequireJS CSS loading plugin.
 * 
 * This file is a modified version of util-fetch.js from the SeaJS project,
 * used under the terms of the MIT license. SeaJS is available at 
 * github.com/seajs.
 * 
 * MIT LICENSE
 * Copyright (c) 2012 Frank Wang, http://seajs.org/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */
define(function() {

  if (typeof document === 'undefined') {
    return {
      load: function (name, parentRequire, load, config) {
        //we are not running in the browser, so short circuit all this
        //browser-specific behavior - css will be loaded in the browser
        //at run time
        load();
      }
    }
  }
  
  var doc = document,
      head = doc.head ||
        doc.getElementsByTagName('head')[0] ||
        doc.documentElement,
      baseElement = head.getElementsByTagName('base')[0],
      READY_STATE_RE = /loaded|complete|undefined/,
      UA = navigator.userAgent,

      // `onload` event is supported in WebKit since 535.23
      // Ref:
      //  - https://bugs.webkit.org/show_activity.cgi?id=38995
      isOldWebKit = Number(UA.replace(/.*AppleWebKit\/(\d+)\..*/, '$1')) < 536,

      // `onload/onerror` event is supported since Firefox 9.0
      // Ref:
      //  - https://bugzilla.mozilla.org/show_bug.cgi?id=185236
      //  - https://developer.mozilla.org/en/HTML/Element/link#Stylesheet_load_events
      isOldFirefox = UA.indexOf('Firefox') > 0 &&
          !('onload' in document.createElement('link'));

      
  function poll(node, callback) {
    var isLoaded;

    // for WebKit < 536
    if (isOldWebKit) {
      if (node['sheet']) {
        isLoaded = true;
      }
    }
    // for Firefox < 9.0
    else if (node['sheet']) {
      try {
        if (node['sheet'].cssRules) {
          isLoaded = true;
        }
      } catch (ex) {
        // The value of `ex.name` is changed from
        // 'NS_ERROR_DOM_SECURITY_ERR' to 'SecurityError' since Firefox 13.0
        // But Firefox is less than 9.0 in here, So it is ok to just rely on
        // 'NS_ERROR_DOM_SECURITY_ERR'
        if (ex.name === 'NS_ERROR_DOM_SECURITY_ERR') {
          isLoaded = true;
        }
      }
    }

    setTimeout(function () {
      if (isLoaded) {
        // Place callback in here due to giving time for style rendering.
        callback();
      } else {
        poll(node, callback);
      }
    }, 1);
  }

  function styleOnload(node, callback) {
    // for Old WebKit and Old Firefox
    if (isOldWebKit || isOldFirefox) {
      //util.log('Start poll to fetch css')

      setTimeout(function () {
        poll(node, callback);
      }, 1); // Begin after node insertion
    }
    else {
      node.onload = node.onerror = function() {
        node.onload = node.onerror = null;
        node = undefined;
        callback();
      }
    }
  }
  
  function noop() { }

  function fetch(url, callback, charset) {
    var node = document.createElement('link');

    if (charset) {
      if (typeof charset === 'function') {
        charset = charset(url);
      }
      
      node.charset = charset;
    }

    styleOnload(node, callback || noop);

    node.rel = 'stylesheet';
    node.href = url;

    // ref: #185 & http://dev.jquery.com/ticket/2709
    if (baseElement) {
      head.insertBefore(node, baseElement);
    } else {
      head.appendChild(node);
    }
  }

  function load(name, parentRequire, load, config) {
    var css = name + '.css',
        url = parentRequire.toUrl(css);
    fetch(url, load, 'UTF-8');
    
  } 



  /**
   * References:
   *  - http://unixpapa.com/js/dyna.html
   *  - ../test/research/load-js-css/test.html
   *  - ../test/issues/load-css/test.html
   *  - http://www.blaze.io/technical/ies-premature-execution-problem/
   */

  return {
    load: load
  };
});
