/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.history.BTrendFlags;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BOracleDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    public static final Type TYPE = Sys.loadType(BOracleDeprecatedDialect.class);

    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms db, Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.getMetaData().getTables(null, db.getUserName().toUpperCase(), tableName, new String[]{"TABLE"});
        boolean hasNext = rs.next();
        rs.close();
        return hasNext;
    }

    protected float getMaxFloat() {
        return Float.POSITIVE_INFINITY;
    }

    protected float getMinFloat() {
        return Float.NEGATIVE_INFINITY;
    }

    protected double getMaxDouble() {
        return Double.POSITIVE_INFINITY;
    }

    protected double getMinDouble() {
        return Double.NEGATIVE_INFINITY;
    }

    public String makeAddColumnSql(String tableName, String columnName, BSqlType columnType, int columnSize, String defaultValue) {
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ").append(tableName).append(" ");
        sql.append("ADD ").append(columnName).append(" ").append(this.getDataType(columnType));
        if (columnSize > -1) {
            sql.append("(" + columnSize + ") ");
        } else {
            sql.append(" ");
        }
        sql.append("DEFAULT ");
        if (columnType.equals((Object)BSqlType.sqlVarchar) || columnType.equals((Object)BSqlType.sqlNVarchar)) {
            defaultValue = "'" + defaultValue + "'";
        }
        sql.append(defaultValue).append(" NOT NULL");
        return sql.toString();
    }

    public String makeAlterColumnTypeSql(String tableName, String columnName, BSqlType targetType, int columnSize) {
        String sql = "ALTER TABLE " + tableName + " MODIFY (" + columnName + " " + this.getDataType(targetType) + "(" + columnSize + "))";
        return sql;
    }

    public String makeDropIndexSql(String indexName, String tableName) {
        return "DROP INDEX " + indexName;
    }

    public String getSqlType(Type type, BFacets facets) {
        int width = this.getVarcharSize(facets);
        if (type.equals(BString.TYPE)) {
            return this.getStringType(width);
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "INT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "REAL";
        }
        if (type.equals(BDouble.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "TIMESTAMP";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "INT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "CHAR(1)";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return this.getStringType(width);
    }

    private String getStringType(int width) {
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return "NVARCHAR2(" + width + ")";
        }
        return "VARCHAR2(" + width + ")";
    }

    public long getTimestampAccuracy() {
        return 1L;
    }

    public String getPrimaryKeySql() {
        return "INT PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 30;
    }

    public int getMaxIndexName() {
        return 30;
    }

    public int getMaxColumnName() {
        return 30;
    }

    public int getMaxSequenceName() {
        return 30;
    }

    public boolean hasSequences() {
        return true;
    }

    public boolean allowsUnicode() {
        return false;
    }
}

