/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.oracle.BOracleConnectionPool;
import com.tridium.rdb.oracle.history.BOracleHistoryDeviceExt;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.AccessController;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.DelegatingConnection;

public class BOracleDatabase
extends BRdbms {
    public static final Property port = BOracleDatabase.newProperty((int)0, (int)1521, null);
    public static final Property serviceName = BOracleDatabase.newProperty((int)0, (String)"", null);
    public static final Property histories = BOracleDatabase.newProperty((int)0, (BValue)new BOracleHistoryDeviceExt(), null);
    public static final Property connectionPool = BOracleDatabase.newProperty((int)4, (BValue)new BOracleConnectionPool(), null);
    public static final Type TYPE = Sys.loadType(BOracleDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){
        private static final String SEQUENCE_SUFFIX = "SQ";
        private static final int MAX_SEQUENCE_LEN = 30;

        public String getValidationQuery() {
            return "select 1 from dual";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 0;
        }

        public String getIdentityCreation() {
            throw new UnsupportedOperationException();
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            return this.makeSuffixName(tableName, SEQUENCE_SUFFIX, 30);
        }

        private String makeSuffixName(String tableName, String suffix, int max) {
            int slen;
            int tlen = tableName.length();
            if (tlen + (slen = suffix.length()) <= max) {
                return tableName + suffix;
            }
            return tableName.substring(0, max - slen) + suffix;
        }

        public String getSequenceLookup(String tableName) {
            return "SELECT " + this.getSequenceName(tableName) + ".NEXTVAL FROM DUAL";
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LENGTH";
        }

        public int getMaxTableName() {
            return 30;
        }

        public int getMaxIndexName() {
            return 30;
        }

        public int getMaxConstraintName() {
            return 30;
        }

        public int getMaxColumnName() {
            return 30;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INT";
        }

        public String getLongType() {
            return "INT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "FLOAT";
        }

        public String getCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR2" : "VARCHAR2";
        }

        public String getUuidType() {
            return "RAW(16)";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return false;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return !BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcMillis);
        }

        public boolean useUtcTimestamps() {
            return BOracleDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "BLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return false;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbPrep, int index, byte[] bytes) {
            try {
                Connection conn = rdbPrep.getConnection();
                PreparedStatement prep = rdbPrep.getStatement();
                Connection oracleConnection = conn;
                if (oracleConnection instanceof DelegatingConnection) {
                    oracleConnection = ((DelegatingConnection)oracleConnection).getInnermostDelegate();
                }
                Blob blob = oracleConnection.createBlob();
                try (BufferedOutputStream out = new BufferedOutputStream(blob.setBinaryStream(1L));){
                    ((OutputStream)out).write(bytes);
                    ((OutputStream)out).flush();
                    prep.setBlob(index, blob);
                }
            }
            catch (IOException | SQLException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public String getClobType() {
            return BOracleDatabase.this.getUseUnicodeEncodingScheme() ? "NCLOB" : "CLOB";
        }

        public boolean usesDefaultClobTranslator() {
            return false;
        }

        public void setClobValue(RdbmsPreparedStatement rdbPrep, int index, String str) {
            try {
                Connection conn = rdbPrep.getConnection();
                PreparedStatement prep = rdbPrep.getStatement();
                Connection oracleConnection = conn;
                if (oracleConnection instanceof DelegatingConnection) {
                    oracleConnection = ((DelegatingConnection)oracleConnection).getInnermostDelegate();
                }
                Clob clob = oracleConnection.createClob();
                try (Writer writer = clob.setCharacterStream(0L);){
                    writer.write(str.toCharArray());
                    writer.flush();
                    prep.setClob(index, clob);
                }
            }
            catch (IOException | SQLException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BOracleDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "SET NULL";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return 1;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 2;
        }

        public int getJdbcTypeFloat() {
            return 2;
        }

        public int getJdbcTypeInt() {
            return 2;
        }

        public int getJdbcTypeLong() {
            return 2;
        }

        public int getJdbcTypeTimestamp() {
            return 93;
        }

        public int getJdbcTypeUuid() {
            return -3;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public String getServiceName() {
        return this.getString(serviceName);
    }

    public void setServiceName(String v) {
        this.setString(serviceName, v, null);
    }

    public BOracleHistoryDeviceExt getHistories() {
        return (BOracleHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BOracleHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public BOracleConnectionPool getConnectionPool() {
        return (BOracleConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BOracleConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOracleDatabase() {
    }

    public BOracleDatabase(BOrd address, int port, String serviceName) {
        this.setHostAddress(address);
        this.setPort(port);
        this.setServiceName(serviceName);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbOracle");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }
}

