/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator;
import com.tridium.ddfIp.udp.identify.BIDdfUdpDeviceId;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BDdfUdpTransmitter
extends BDdfTransmitter {
    public static final Property sendToAddress = BDdfUdpTransmitter.newProperty((int)0, (BValue)new BDdfIpAddressPort(), (BFacets)MGR_INCLUDE);
    public static final Property maxRetryCount = BDdfUdpTransmitter.newProperty((int)0, (int)3, (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))));
    public static final Type TYPE = Sys.loadType(BDdfUdpTransmitter.class);
    public static final Lexicon LEX = Lexicon.make(BDdfUdpTransmitter.class);
    public static final String lexkeyRequestDoesNotSupportUdp = "RequestDoesNotSupportUdp";
    public static final String requestDoesNotSupportUdp = LEX.getText("RequestDoesNotSupportUdp");

    public BDdfIpAddressPort getSendToAddress() {
        return (BDdfIpAddressPort)this.get(sendToAddress);
    }

    public void setSendToAddress(BDdfIpAddressPort v) {
        this.set(sendToAddress, (BValue)v, null);
    }

    public int getMaxRetryCount() {
        return this.getInt(maxRetryCount);
    }

    public void setMaxRetryCount(int v) {
        this.setInt(maxRetryCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDdfUdpCommunicator getUdpCommunicator() {
        return (BDdfUdpCommunicator)this.getDdfCommunicator();
    }

    public void forceTransmit(BIDdfRequest ddfRequest) throws Exception {
        BDdfIpAddressPort destUdpAddr = this.getUdpSendToAddress(ddfRequest);
        byte[] udpData = ddfRequest.toByteArray();
        if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace(udpData, destUdpAddr);
        }
        this.getUdpCommunicator().getUdpTransmitSocket().send(new DatagramPacket(udpData, udpData.length, destUdpAddr.getInetAddress(), destUdpAddr.getIpPort()));
    }

    public BDdfIpAddressPort getUdpSendToAddress(BIDdfRequest ddfRequest) {
        BDdfIdParams deviceIdForRequest = ddfRequest.getDeviceId();
        if (deviceIdForRequest instanceof BIDdfUdpDeviceId) {
            return ((BIDdfUdpDeviceId)deviceIdForRequest).getUdpAddress();
        }
        return this.getSendToAddress();
    }

    private void trace(byte[] out, BDdfIpAddressPort udpAddress) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("TX:" + udpAddress.getIpAddress() + ':' + udpAddress.getIpPort());
        ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])out, (int)0, (int)out.length);
        pw.flush();
        pw.close();
        this.getDdfCommunicator().getLog().trace(sw.toString());
    }

    public int getTransmitFromPort() {
        return -1;
    }
}

