/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.comm;

import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfIpCommunicator
extends BDdfCommunicator {
    public static final Property networkInterface = BDdfIpCommunicator.newProperty((int)0, (BValue)BDdfIpAdapter.makeDefaultLocalHost(), (BFacets)BFacets.make((String)"fieldEditor", (String)"devIpDriver:DdfIpAdapterEditor"));
    public static final Property hostIpAdapters = BDdfIpCommunicator.newProperty((int)6, (BValue)new BVector(), null);
    public static final Action refreshHostIpAdapters = BDdfIpCommunicator.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDdfIpCommunicator.class);
    public static final int MIN_DYNAMIC_PORT = 49152;
    public static final int MAX_DYNAMIC_PORT = 65535;
    private static BDdfIpAdapter localHostAdapter = new BDdfIpAdapter("localhost", "localhost", "localhost");

    public BDdfIpAdapter getNetworkInterface() {
        return (BDdfIpAdapter)this.get(networkInterface);
    }

    public void setNetworkInterface(BDdfIpAdapter v) {
        this.set(networkInterface, (BValue)v, null);
    }

    public BVector getHostIpAdapters() {
        return (BVector)this.get(hostIpAdapters);
    }

    public void setHostIpAdapters(BVector v) {
        this.set(hostIpAdapters, (BValue)v, null);
    }

    public BVector refreshHostIpAdapters() {
        return (BVector)this.invoke(refreshHostIpAdapters, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void communicatorStarted() throws Exception {
        super.communicatorStarted();
        try {
            this.refreshHostIpAdapters();
            Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)1), (Action)refreshHostIpAdapters, null);
        }
        catch (ActionInvokeException aie) {
            if (aie.getCause() instanceof ServiceNotFoundException) {
                this.getLog().message("Ddf Ip Communicator running in proxy mode: " + this.getSlotPath());
            }
            throw new BajaRuntimeException((Throwable)aie);
        }
        this.ipCommunicatorStarted();
    }

    public final void communicatorStopped() throws Exception {
        this.ipCommunicatorStopped();
        super.communicatorStopped();
    }

    public void ipCommunicatorStarted() throws Exception {
    }

    public void ipCommunicatorStopped() throws Exception {
    }

    public BVector doRefreshHostIpAdapters() {
        this.getHostIpAdapters().removeAll();
        BTcpIpAdapterSettings[] ethernetAdapters = this.getHostEthernetAdapters();
        for (int i = 0; i < ethernetAdapters.length; ++i) {
            if (!ethernetAdapters[i].getIsAdapterEnabled() || ethernetAdapters[i].getIpAddress().equals("")) continue;
            this.getHostIpAdapters().add("adapter?", (BValue)new BDdfIpAdapter(ethernetAdapters[i].getAdapterId(), ethernetAdapters[i].getDescription(), ethernetAdapters[i].getIpAddress()), 1);
        }
        return this.getHostIpAdapters();
    }

    public BDdfIpAdapter[] getHostIpAdaptersArray() {
        BVector hostIpAdapters = this.getHostIpAdapters();
        return (BDdfIpAdapter[])hostIpAdapters.getChildren(BDdfIpAdapter.class);
    }

    public BDdfIpAdapter getNetworkAdapter() {
        try {
            BDdfIpAdapter networkInterface = this.getNetworkInterface();
            if (networkInterface.isDescriptionOnlyAdapter()) {
                this.updateNetworkInterfaceFromDescription(networkInterface);
            }
            this.updateIpAddress(networkInterface);
            return networkInterface;
        }
        catch (ServiceNotFoundException snfe) {
            return localHostAdapter;
        }
    }

    protected boolean updateNetworkInterfaceFromDescription(BDdfIpAdapter networkInterface) {
        int i;
        BDdfIpAdapter[] hostAdapters = this.getHostIpAdaptersArray();
        boolean adapterFound = false;
        for (i = 0; i < hostAdapters.length && !adapterFound; ++i) {
            if (!hostAdapters[i].getDescription().trim().equals(networkInterface.getDescription())) continue;
            adapterFound = true;
            networkInterface.copyFrom((BComplex)hostAdapters[i]);
        }
        if (!adapterFound) {
            for (i = 0; i < hostAdapters.length && !adapterFound; ++i) {
                if (!hostAdapters[i].getDescription().trim().equalsIgnoreCase(networkInterface.getDescription())) continue;
                adapterFound = true;
                networkInterface.copyFrom((BComplex)hostAdapters[i]);
            }
        }
        return adapterFound;
    }

    protected void updateIpAddress(BDdfIpAdapter givenNetworkInterface) {
        BTcpIpAdapterSettings[] networkInterfaces = this.getHostEthernetAdapters();
        for (int i = 0; i < networkInterfaces.length; ++i) {
            if (!networkInterfaces[i].getAdapterId().equals(givenNetworkInterface.getAdapterId())) continue;
            givenNetworkInterface.setIpAddress(networkInterfaces[i].getIpAddress());
            break;
        }
    }

    private BTcpIpAdapterSettings[] getHostEthernetAdapters() {
        BTcpIpPlatformService svc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        svc.lease();
        svc.checkPropertiesLoaded();
        BTcpIpHostSettings platformTcpSettings = svc.getSettings();
        return (BTcpIpAdapterSettings[])platformTcpSettings.getAdapters().getChildren(BTcpIpAdapterSettings.class);
    }
}

