/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.comm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDdfIpAdapter
extends BStruct {
    public static final Property adapterId = BDdfIpAdapter.newProperty((int)0, (String)"", null);
    public static final Property description = BDdfIpAdapter.newProperty((int)0, (String)"", null);
    public static final Property ipAddress = BDdfIpAdapter.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BDdfIpAdapter.class);
    public static final String DEFAULT_ADAPTER_ID = "[***DEFAULT***]";
    public static final String DEFAULT_IP_ADDR = "[***DEFAULT***]";
    public static final String DEFAULT_DESCRIPTION = "[***DEFAULT***]";

    public String getAdapterId() {
        return this.getString(adapterId);
    }

    public void setAdapterId(String v) {
        this.setString(adapterId, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDdfIpAdapter() {
    }

    public BDdfIpAdapter(String id, String desc, String ip) {
        this.setAdapterId(id);
        this.setDescription(desc);
        this.setIpAddress(ip);
    }

    public static BDdfIpAdapter makeDefaultLocalHost() {
        return new BDdfIpAdapter("[***DEFAULT***]", "[***DEFAULT***]", "[***DEFAULT***]");
    }

    public boolean isDefaultLocalHost() {
        return this.getAdapterId().equals("[***DEFAULT***]") && this.getDescription().equals("[***DEFAULT***]") && this.getIpAddress().equals("[***DEFAULT***]");
    }

    public void becomeDescriptionOnlyAdapter(String desc) {
        this.setDescription(desc);
        this.setAdapterId("[***DEFAULT***]");
        this.setIpAddress("[***DEFAULT***]");
    }

    public boolean isDescriptionOnlyAdapter() {
        return !this.getDescription().equals("[***DEFAULT***]") && this.getAdapterId().equals("[***DEFAULT***]");
    }

    public void becomeDefaultLocalHostAdapter() {
        this.setDescription("[***DEFAULT***]");
        this.setAdapterId("[***DEFAULT***]");
        this.setIpAddress("[***DEFAULT***]");
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.isDefaultLocalHost()) {
            return Sys.getLocalHost(null);
        }
        if (this.isDescriptionOnlyAdapter()) {
            throw new UnknownHostException("Unrecognized network interface: " + this.getDescription());
        }
        return InetAddress.getByName(this.getIpAddress());
    }
}

