/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.wb.BEdeConfigFE;
import com.tridium.bacnetEde.wb.BWbEdeService;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="updateSelection")
public class BEdeConfigSelector
extends BEdgePane {
    public static final Action updateSelection = BEdeConfigSelector.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BEdeConfigSelector.class);
    private static final Lexicon lex = Lexicon.make(BEdeConfigSelector.class);
    private static final String LBL_CONFIG_ID = lex.getText("edeconfig.labels.selectionlist");
    private static final String LBL_CONFIG_ADD_BUTTON = lex.getText("edeconfig.labels.addButton");
    private static final String LBL_FILE_CONFIG = lex.getText("edeconfig.labels.configuration.title");
    private BEdeConfigFE configFE = new BEdeConfigFE();
    private BListDropDown configList = new BListDropDown();

    public void updateSelection() {
        this.invoke(updateSelection, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BEdeConfigSelector() {
        this.buildUI();
    }

    public void buildUI() {
        BGridPane pane = new BGridPane(3);
        pane.add(null, (BValue)new BLabel(LBL_CONFIG_ID));
        BConstrainedPane listContainer = new BConstrainedPane((BWidget)this.configList);
        listContainer.setMinWidth(50.0);
        pane.add(null, (BValue)listContainer);
        pane.add(null, (BValue)new BButton((Command)new CmdNewConfig((BWidget)this)));
        this.setTop((BWidget)pane);
        BWbEdeService service = BWbEdeService.getService();
        BEdeConfig[] configs = (BEdeConfig[])service.getChildren(BEdeConfig.class);
        for (int i = 0; i < configs.length; ++i) {
            ListItem item = new ListItem(configs[i]);
            this.configList.getList().addItem((Object)item);
        }
        this.linkTo((BComponent)this.configList, (Slot)BListDropDown.valueModified, (Slot)updateSelection);
        this.doUpdateSelection();
        this.configFE.setReadonly(true);
        BBorderPane border = new BBorderPane((BWidget)this.configFE, BBorder.solid);
        this.setBottom((BWidget)border);
    }

    public BEdeConfig getSelectedConfig() {
        ListItem selectedItem = (ListItem)this.configList.getSelectedItem();
        if (null != selectedItem) {
            return selectedItem.config;
        }
        return null;
    }

    public void doUpdateSelection() {
        ListItem selectedItem = (ListItem)this.configList.getSelectedItem();
        if (null != selectedItem) {
            this.configFE.loadValue((BObject)selectedItem.config);
            this.relayout();
        }
    }

    private class ListItem {
        String name;
        BEdeConfig config;

        public ListItem(BEdeConfig c) {
            this.name = c.getConfigName();
            this.config = c;
        }

        public String toString() {
            return this.name;
        }
    }

    private class CmdNewConfig
    extends Command {
        public CmdNewConfig(BWidget owner) {
            super(owner, LBL_CONFIG_ADD_BUTTON);
        }

        public CommandArtifact doInvoke() throws Exception {
            BEdeConfig config = new BEdeConfig();
            BEdeConfigFE configFe = new BEdeConfigFE();
            configFe.loadValue((BObject)config, null);
            int result = BDialog.open((BWidget)this.getOwner(), (String)LBL_FILE_CONFIG, (Object)((Object)configFe), (int)3);
            if (result == 1) {
                BWbEdeService service = BWbEdeService.getService();
                service.add(null, (BValue)config);
                config = (BEdeConfig)configFe.saveValue();
                ListItem item = new ListItem(config);
                BEdeConfigSelector.this.configList.getList().addItem((Object)item);
                BEdeConfigSelector.this.configList.setSelectedItem((Object)item);
            }
            return null;
        }
    }
}

