/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.jobs;

import com.tridium.bacnet.job.BBacnetDiscoverDevicesJob;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeReader;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.EdeCursor;
import com.tridium.bacnetEde.jobs.BEdeDiscoveryDevice;
import com.tridium.bacnetEde.wb.BWbEdeService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BDeviceDiscoveryJob
extends BBacnetDiscoverDevicesJob {
    public static final Type TYPE = Sys.loadType(BDeviceDiscoveryJob.class);
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Lexicon edeLex = Lexicon.make(BDeviceDiscoveryJob.class);
    private BEdeConfig config;

    public Type getType() {
        return TYPE;
    }

    public BDeviceDiscoveryJob() {
    }

    public BDeviceDiscoveryJob(BBacnetNetwork network, BEdeConfig config) {
        super(network, null);
        this.config = config;
    }

    public void run(Context cx) throws Exception {
        if (null == this.config || null == this.config.getEdePath()) {
            this.failed((Throwable)new BajaRuntimeException(edeLex.getText("edeimport.discover.job.failure.fileNotSpecified")));
        }
        BWbEdeService service = BWbEdeService.getService();
        BEdeReader reader = service.getReader(this.config);
        EdeCursor cursor = (EdeCursor)reader.cursor();
        this.log().message(edeLex.getText("edeimport.discover.device.job.iterateThroughEDE"));
        cursor.setJobLog(this.log());
        while (cursor.nextDevice()) {
            BEdeRecord record = (BEdeRecord)((Object)cursor.get());
            if (record == null) continue;
            BBacnetAddress sourceAddress = BBacnetAddress.DEFAULT;
            BBacnetObjectIdentifier deviceId = BBacnetObjectIdentifier.make((int)8, (int)record.getObjInstance());
            BBacnetBitString servicesSupported = BBacnetBitString.emptyBitString((int)BacnetBitStringUtil.getBitStringLength((String)"BacnetServicesSupported"));
            BCharacterSetEncoding encoding = BCharacterSetEncoding.unknown;
            String vendorName = lex.getText("deviceManager.unknown");
            String modelName = lex.getText("deviceManager.unknown");
            String firmwareRevision = lex.getText("deviceManager.unknown");
            String applicationSoftwareVersion = lex.getText("deviceManager.unknown");
            String name = record.getObjectName();
            IAmRequest request = new IAmRequest(deviceId, 0, BBacnetSegmentation.noSegmentation, 0);
            BEdeDiscoveryDevice dd = new BEdeDiscoveryDevice(name, request, sourceAddress, -1, encoding, servicesSupported, vendorName, modelName, firmwareRevision, applicationSoftwareVersion, (BEdeRecord)record.newCopy());
            this.add(null, (BValue)dd);
        }
        if (cursor.isParseFailure()) {
            throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.failDiscovery"));
        }
        this.log().message(edeLex.getText("edeimport.edeCursor.discover.point.successDiscoverDevice"));
    }
}

