/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde;

import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.util.CSVReader;
import com.tridium.bacnetEde.util.EDEUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Row;
import javax.baja.data.BIDataValue;
import javax.baja.job.JobLog;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class EdeCursor
extends AbstractTableCursor<BEdeRecord> {
    private boolean parseFailure;
    private static final Property[] recordProps = new Property[]{BEdeRecord.keyName, BEdeRecord.deviceObjInstant, BEdeRecord.objectName, BEdeRecord.objectType, BEdeRecord.objInstance, BEdeRecord.description, BEdeRecord.presentValueDefault, BEdeRecord.minPresentValue, BEdeRecord.maxPresentValue, BEdeRecord.settable, BEdeRecord.cov, BEdeRecord.hiLimit, BEdeRecord.lowLimit, BEdeRecord.stateTextRange, BEdeRecord.units, BEdeRecord.vendorSpecificAddress, BEdeRecord.notificationClass};
    public static final String HEADER_ROW_PROJ_NAME = "PROJECT_NAME";
    public static final String HEADER_ROW_VERSION = "VERSION_OF_REFERENCEFILE";
    public static final String HEADER_ROW_TIMESTAMP = "TIMESTAMP_OF_LAST_CHANGE";
    public static final String HEADER_ROW_AUTHOR = "AUTHOR_OF_LAST_CHANGE";
    public static final String HEADER_ROW_LAYOUT = "VERSION_OF_LAYOUT";
    public static final String HEADER_ROW_RESOURCES = "LIMITED_RESOURCES";
    private Hashtable<String, BEnumRange> stateTextLookup;
    private BEdeRecord record = new BEdeRecord();
    private CSVReader reader;
    private JobLog jobLog;
    public static final Logger logger = Logger.getLogger("bacnet.ede");
    public static final Lexicon edeLex = Lexicon.make(EdeCursor.class);

    public EdeCursor(BITable<BEdeRecord> table, CSVReader reader, Hashtable<String, BEnumRange> stateTexts) {
        super(table);
        this.stateTextLookup = stateTexts;
        this.reader = reader;
    }

    public Context getContext() {
        return null;
    }

    protected boolean advanceCursor() {
        if (null == this.reader) {
            return false;
        }
        String[] currentLine = null;
        while (true) {
            try {
                currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                this.jobLog.message(edeLex.getText("edeimport.edeCursor.discover.readFile.failure"));
                return false;
            }
            if (null == currentLine || currentLine.length == 0) {
                return false;
            }
            if (this.skipLine(currentLine)) continue;
            try {
                this.record = new BEdeRecord();
                this.parseRecord(currentLine);
                return true;
            }
            catch (Exception e) {
                this.parseFailure = true;
                this.jobLog.failed(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure", new Object[]{this.reader.getCurrentLine()}), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public boolean isParseFailure() {
        return this.parseFailure;
    }

    public void setParseFailure(boolean parseFailure) {
        this.parseFailure = parseFailure;
    }

    public Row<BEdeRecord> row() {
        return new EDERecordCursorRow(this, this.getTable(), this.record);
    }

    public boolean nextDevice() {
        boolean deviceFound = false;
        if (null == this.reader) {
            return false;
        }
        try {
            String[] currentLine = null;
            while (!deviceFound && null != (currentLine = this.reader.readLine()) && currentLine.length != 0) {
                if (this.skipLine(currentLine)) continue;
                try {
                    this.record = new BEdeRecord();
                    this.parseRecord(currentLine);
                }
                catch (Exception ex) {
                    this.parseFailure = true;
                    this.jobLog.failed(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure", new Object[]{this.record.getKeyName()}), (Throwable)ex);
                    deviceFound = false;
                    continue;
                }
                deviceFound = this.record.isDevice();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Failed to read and parse line for device.", ioe);
            return false;
        }
        return deviceFound;
    }

    private boolean skipLine(String[] line) {
        if (null != line && line.length > 0) {
            String val = line[0].toUpperCase();
            return val.startsWith("#") || val.startsWith(HEADER_ROW_PROJ_NAME) || val.startsWith(HEADER_ROW_AUTHOR) || val.startsWith(HEADER_ROW_VERSION) || val.startsWith(HEADER_ROW_TIMESTAMP) || val.startsWith(HEADER_ROW_RESOURCES) || val.startsWith(HEADER_ROW_LAYOUT);
        }
        return false;
    }

    private void parseRecord(String[] cols) {
        if (null == cols || cols.length == 0) {
            return;
        }
        for (int i = 0; i < recordProps.length; ++i) {
            boolean required = i < 5;
            this.parseRecordVal(cols[i], recordProps[i], required);
        }
    }

    private void parseRecordVal(String val, Property prop, boolean required) {
        if (val == null || val.equals("")) {
            if (required) {
                throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.valueMissing", new Object[]{prop.getDefaultDisplayName(null)}));
            }
            this.record.set(prop, prop.getDefaultValue());
            return;
        }
        if (BEdeRecord.keyName.equals(prop)) {
            this.record.set(prop, (BValue)BString.make((String)SlotPath.escape((String)val)));
        } else if (BEdeRecord.deviceObjInstant.equals(prop)) {
            this.setNumericVal(val, prop, BInteger.TYPE);
        } else if (BEdeRecord.objectName.equals(prop)) {
            this.record.set(prop, (BValue)BString.make((String)SlotPath.escape((String)val)));
        } else if (BEdeRecord.objectType.equals(prop)) {
            try {
                BBacnetObjectType objType = BBacnetObjectType.make((int)BInteger.make((String)val).getInt());
                this.record.set(prop, (BValue)objType);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
            }
        } else if (BEdeRecord.objInstance.equals(prop)) {
            this.setNumericVal(val, prop, BInteger.TYPE);
        } else if (BEdeRecord.description.equals(prop)) {
            this.record.set(prop, (BValue)BString.make((String)SlotPath.escape((String)val)));
        } else if (BEdeRecord.presentValueDefault.equals(prop)) {
            if (val != null && !val.isEmpty()) {
                if (EDEUtil.isNumericPoint(this.record.getObjectType().getOrdinal())) {
                    try {
                        BDouble.make((String)val);
                        this.record.set(prop, (BValue)BString.make((String)val));
                    }
                    catch (Exception e) {
                        throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
                    }
                } else if (EDEUtil.isMultiStatePoint(this.record.getObjectType().getOrdinal())) {
                    this.record.set(prop, (BValue)BString.make((String)SlotPath.escape((String)val)));
                } else if (EDEUtil.isBooleanPoint(this.record.getObjectType().getOrdinal())) {
                    BBoolean bBoolean = val.toLowerCase().equals("true") ? BBoolean.TRUE : BBoolean.FALSE;
                    this.record.set(prop, (BValue)BString.make((String)SlotPath.escape((String)bBoolean.getTag())));
                }
            }
        } else if (BEdeRecord.minPresentValue.equals(prop)) {
            this.setNumericVal(val, prop, BDouble.TYPE);
        } else if (BEdeRecord.maxPresentValue.equals(prop)) {
            this.setNumericVal(val, prop, BDouble.TYPE);
        } else if (BEdeRecord.settable.equals(prop)) {
            BBoolean boolVal = val.toLowerCase().equals("y") ? BBoolean.TRUE : BBoolean.FALSE;
            this.record.set(prop, (BValue)boolVal);
        } else if (BEdeRecord.cov.equals(prop)) {
            BBoolean boolVal = val.toLowerCase().equals("y") ? BBoolean.TRUE : BBoolean.FALSE;
            this.record.set(prop, (BValue)boolVal);
        } else if (BEdeRecord.hiLimit.equals(prop)) {
            this.setNumericVal(val, prop, BDouble.TYPE);
        } else if (BEdeRecord.lowLimit.equals(prop)) {
            this.setNumericVal(val, prop, BDouble.TYPE);
        } else if (BEdeRecord.stateTextRange.equals(prop)) {
            BEnumRange range = this.stateTextLookup.get(val);
            if (null == range) {
                range = BEnumRange.NULL;
            } else if (EDEUtil.isMultiStatePoint(this.record.getObjectType().getOrdinal())) {
                try {
                    range.get(this.record.getPresentValueDefault());
                }
                catch (Exception e) {
                    range = BEnumRange.NULL;
                }
            } else if (EDEUtil.isBooleanPoint(this.record.getObjectType().getOrdinal()) && range.getOrdinals().length != 2) {
                range = BEnumRange.NULL;
            }
            if (!val.isEmpty() && BEnumRange.NULL.equals((Object)range)) {
                throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
            }
            this.record.set(prop, (BValue)range);
        } else if (BEdeRecord.units.equals(prop)) {
            try {
                int ordinal = Integer.parseInt(val);
                BUnit niagaraUnits = BBacnetEngineeringUnits.getNiagaraUnits((int)ordinal);
                if (null == niagaraUnits) {
                    throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
                }
                BFacets map = BFacets.make((String)"units", (BIDataValue)niagaraUnits);
                this.record.setUnits(map);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
            }
        } else if (BEdeRecord.notificationClass.equals(prop)) {
            this.setNumericVal(val, prop, BInteger.TYPE);
        }
    }

    private void setNumericVal(String val, Property prop, Type type) throws BajaRuntimeException {
        try {
            if (BInteger.TYPE.is(type)) {
                this.record.set(prop, (BValue)BInteger.make((String)val));
            } else if (BDouble.TYPE.is(type)) {
                this.record.set(prop, (BValue)BDouble.make((String)val));
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException(edeLex.getText("edeimport.edeCursor.discover.parseReadLine.failure.invalidValue", new Object[]{prop.getDefaultDisplayName(null)}));
        }
    }

    public JobLog getJobLog() {
        return this.jobLog;
    }

    public void setJobLog(JobLog jobLog) {
        this.jobLog = jobLog;
    }

    static class EDERecordCursorRow<T extends BEdeRecord>
    extends AbstractRow<T> {
        final /* synthetic */ EdeCursor this$0;

        EDERecordCursorRow(BITable<T> table, T rowObject) {
            this.this$0 = this$0;
            super(table, rowObject);
        }

        public BIObject cell(Column column) {
            BEdeRecord currentRecord = (BEdeRecord)this.rowObject();
            if (null == currentRecord) {
                return null;
            }
            return currentRecord.get(column.getName());
        }

        public BFacets getCellFacets(Column column) {
            BEdeRecord currentRecord = (BEdeRecord)this.rowObject();
            if (null == currentRecord) {
                return BFacets.NULL;
            }
            String name = column.getName();
            Slot slot = currentRecord.getSlot(name);
            return currentRecord.getSlotFacets(slot);
        }

        public Row<T> safeCopy() {
            BEdeRecord newCopy = (BEdeRecord)((BEdeRecord)this.rowObject()).newCopy().asComplex();
            return new EDERecordCursorRow(this.this$0, this.getTable(), newCopy);
        }
    }
}

