/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx.discover;

import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BIVideoEventSource;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmRecipient;
import com.tridiumx.accessDriver.BSecAlarmSourceExt;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.videoHx.VideoHxUtil;
import com.tridiumx.videoHx.discover.BAutoDiscoverPointsJob;
import com.tridiumx.videoHx.discover.BHxVideoEventDiscoverView;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BHxVideoEventTableView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxVideoEventTableView.class);
    public static final BHxVideoEventTableView INSTANCE = new BHxVideoEventTableView();
    public static final Type TYPE = Sys.loadType(BHxVideoEventTableView.class);
    static String[] POINT_FIELDS = new String[]{"displayName", "type"};
    static BTypeSpec[] POINT_FIELD_TYPES = new BTypeSpec[]{BString.TYPE.getTypeSpec(), BTypeSpec.TYPE.getTypeSpec()};
    Command addDiscovered = new AddDiscovered((BHxView)this);

    public Type getType() {
        return TYPE;
    }

    public BHxVideoEventTableView() {
        this.registerEvent((Event)this.addDiscovered);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (this.hasUsefulPreferences(op)) {
            return new SmartCommand[]{this.discover, this.preferencesCommand, this.delete, this.renameCommand, this.hyperlinkCommand, this.filterCommand, this.refresh, this.exportCommand, this.learnMode};
        }
        return new SmartCommand[]{this.discover, this.delete, this.renameCommand, this.hyperlinkCommand, this.filterCommand, this.refresh, this.exportCommand, this.learnMode};
    }

    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxVideoEventDiscoverView.INSTANCE;
    }

    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BControlPoint.TYPE.getTypeSpec();
    }

    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return VideoHxUtil.getLeafType(op.get().asComplex()).getTypeSpec();
    }

    public BJob submitDiscoveryJob(HxOp op) {
        BComponent deviceSys = (BComponent)op.get();
        if (this.hasUsefulPreferences(op)) {
            return VideoHxUtil.submitDiscoveryJob(deviceSys);
        }
        BAutoDiscoverPointsJob job = new BAutoDiscoverPointsJob(deviceSys);
        BOrd ord = job.submit((Context)op);
        return (BJob)ord.get((BObject)deviceSys);
    }

    public BQuery getDiscoverQuery(HxOp op) {
        BObject o;
        BOrd jobOrd;
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getLearnRowTypeSpec(op)));
        query.select(new BProjection());
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BString.TYPE, (String)"eventType", (String)secUtilLex.getText("eventType"));
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BBoolean.TYPE, (String)"dbExistence", (String)secUtilLex.getText("eventExists"));
        QueryUtil.addHiddenColumns((BQuery)query);
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        if (jobOrdStr != null && (jobOrd = BOrd.make((String)jobOrdStr)) != null && (o = jobOrd.get()) instanceof BJob) {
            BJob job = (BJob)o;
            BHxVideoEventTableView.updateExistenceFacets(job, op);
            query.add("base", (BValue)job.getAbsoluteOrd());
        }
        return query;
    }

    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getDeviceTypeSpec(op)));
        query.select(new BProjection());
        for (int i = 0; i < POINT_FIELDS.length; ++i) {
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)TypeSpecPath.DISPLAY_NAME);
        }
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    public boolean showDiscoveryDialog(HxOp op) {
        if (!this.hasUsefulPreferences(op)) {
            return false;
        }
        BNDiscoveryPreferences preferences = (BNDiscoveryPreferences)op.get().asComponent().get("discoveryPreferences");
        return !preferences.getDoNotAskAgain();
    }

    public boolean hasUsefulPreferences(HxOp op) {
        return VideoHxUtil.hasUsefulPreferences(op.get().asComponent());
    }

    public Tab getDiscoveryPreferencesTab(HxOp op) {
        BNDiscoveryPreferences preferences = (BNDiscoveryPreferences)op.get().asComponent().get("discoveryPreferences");
        HxOp tabOp = op.make("additionalFields", (BObject)preferences, null);
        SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, tabOp);
    }

    static void updateExistenceFacets(BJob job, HxOp op) {
        VideoHxUtil.updateExistenceFacetsForEvents(job, op);
    }

    public String getPageTitle(HxOp op) {
        return "";
    }

    class AddDiscovered
    extends SmartCommand {
        AddDialog dlg;

        public AddDiscovered(BHxView view) {
            super(view);
            this.dlg = new AddDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String addName = op.getFormValue("addName");
            Type proxyType = ((BPointDeviceExt)op.get()).getProxyExtType();
            Object[] selectionList = BHxQueryTableView.getSubjects((HxOp)op.make("discover", (OrdTarget)op));
            if (selectionList != null && selectionList.length == 1) {
                BIVideoEventSource eventSource;
                BComplex complexLeaf = (BComplex)selectionList[0];
                BControlPoint controlPoint = VideoHxUtil.eventLeafToPoint(complexLeaf, proxyType, (Context)op);
                BSecAlarmSourceExt alarmExt = new BSecAlarmSourceExt();
                alarmExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
                alarmExt.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName% %parent.displayName%"));
                if (controlPoint.getProxyExt().getType().is(BIVideoEventSource.TYPE) && (eventSource = (BIVideoEventSource)controlPoint.getProxyExt()).getEventTypeEnum().equals((Object)BVideoEventTypesEnum.motionStarted)) {
                    BComponent camera = ((BComponent)op.get()).getParent().asComponent();
                    BOrd cameraOrd = camera.getSlotPathOrd();
                    BOrd cameraHandleOrd = camera.getHandleOrd();
                    BFacets facets = BFacets.make((String[])new String[]{"cameraOrd", "cameraHandleOrd", "startRecording"}, (BIDataValue[])new BIDataValue[]{BString.make((String)cameraOrd.toString()), BString.make((String)cameraHandleOrd.toString()), BBoolean.FALSE});
                    alarmExt.setMetaData(BFacets.make((BFacets)alarmExt.getMetaData(), (BFacets)facets));
                }
                controlPoint.add("Alarm$20Ext?", (BValue)alarmExt);
                ((BComponent)op.get()).add(addName + "?", (BValue)controlPoint);
                this.configureVideoRecipient((BComponent)alarmExt, op);
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        private void configureVideoRecipient(BComponent alarmExt, HxOp op) {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmRecipient videoRecipient = (BAlarmRecipient)alarmService.get("videoRecipient");
            if (videoRecipient == null) {
                videoRecipient = new BVideoAlarmRecipient();
                alarmService.add("videoRecipient", (BValue)videoRecipient);
            }
            String alarmClassName = alarmExt.get("alarmClass").toString();
            alarmService.lease();
            BAlarmClass ac = alarmService.lookupAlarmClass(alarmClassName);
            BLink[] links = videoRecipient.getLinks((Slot)BAlarmRecipient.routeAlarm);
            for (int l = 0; l < links.length; ++l) {
                if (!links[l].getSourceComponent().equals((Object)ac)) continue;
            }
            LinkCheck checkLink = videoRecipient.checkLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op);
            if (checkLink.isValid()) {
                BLink link = videoRecipient.makeLink((BComponent)ac, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, (Context)op);
                videoRecipient.add(null, (BValue)link);
            }
        }

        class AddDialog
        extends Dialog {
            public AddDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                Object[] selectionList = BHxQueryTableView.getSubjects((HxOp)op.make("discover", (OrdTarget)op));
                String addName = VideoHxUtil.getDiscoveryNameForLeaf(selectionList[0]);
                if (addName != null) {
                    addName = SlotPath.unescape((String)addName);
                }
                if (addName == null || addName.equals("")) {
                    addName = TextUtil.toFriendly((String)((BComplex)selectionList[0]).getDisplayName((Context)op));
                }
                HtmlWriter out = op.getHtmlWriter();
                HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
                HxTabUtil.startRow((String)AddDiscovered.this.lex.getText("displayName"), (HtmlWriter)out, (HxOp)op);
                out.w((Object)"<input type='text' name='").w((Object)op.scope("addName")).w((Object)"' width='40'");
                out.attr("value", addName);
                out.w((Object)"/>");
                HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
                HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            }
        }
    }
}

