/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.VideoCommand;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDriverContainer;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxVideoCameraPickerFE
extends BHxFieldEditor {
    public static final Lexicon lex = Lexicon.make(BHxVideoCameraPickerFE.class);
    public static final BHxVideoCameraPickerFE INSTANCE = new BHxVideoCameraPickerFE();
    public static final Type TYPE = Sys.loadType(BHxVideoCameraPickerFE.class);
    Command cameraChanged = new CameraChangedCommand((BHxView)this);

    public Type getType() {
        return TYPE;
    }

    public BHxVideoCameraPickerFE() {
        this.registerEvent((Event)this.cameraChanged);
    }

    public void write(HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)"module://entsecHx/rc/securityUtilHx/select.js");
        op.addJavaScript(ord);
        String cameraOrd = ((BString)op.get()).getString();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)("<select name='" + op.scope("videoCamera") + "' onchange='" + this.cameraChanged.getInvokeCode(op) + "'"));
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        out.w((Object)"<option value='none'>").safe((Object)lex.getText("selectVideoCamera")).w((Object)"</option>");
        try {
            TableCursor videoCameras = null;
            if (cameraOrd.startsWith("station:")) {
                String stationName = null;
                stationName = cameraOrd.indexOf("|") == -1 ? cameraOrd.substring(cameraOrd.indexOf(":") + 1) : cameraOrd.substring(cameraOrd.indexOf(":") + 1, cameraOrd.indexOf("|"));
                if (!stationName.equals(Sys.getStation().getStationName())) {
                    BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                    BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                    if (station != null) {
                        BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                        BComponent drivers = foxSession.getService(BDriverContainer.TYPE);
                        BComponent[] cameras = this.getRemoteCameras(drivers);
                        for (int i = 0; i < cameras.length; ++i) {
                            BComponent camera = cameras[i];
                            camera.lease();
                            this.writeCameraOption(camera, cameraOrd, stationName, op);
                        }
                        return;
                    }
                } else {
                    videoCameras = ((BITable)BOrd.make((String)"bql:SELECT * FROM videoDriver:IVideoCamera").get((BObject)Sys.getService((Type)BDriverContainer.TYPE))).cursor();
                }
            } else {
                videoCameras = ((BITable)BOrd.make((String)"bql:SELECT * FROM videoDriver:IVideoCamera").get((BObject)Sys.getService((Type)BDriverContainer.TYPE))).cursor();
            }
            while (videoCameras.next()) {
                this.writeCameraOption((BComponent)videoCameras.get(), cameraOrd, null, op);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.w((Object)"</select>");
    }

    private void writeCameraOption(BComponent camera, String cameraOrd, String remoteStation, HxOp op) throws Exception {
        if (Flags.isHidden((BComplex)camera.getParent(), (Slot)camera.getPropertyInParent())) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        if (remoteStation != null) {
            out.w((Object)("<option value='station:" + remoteStation + "|" + camera.getHandleOrd() + "'"));
        } else {
            out.w((Object)("<option value='" + camera.getHandleOrd() + "'"));
        }
        if (cameraOrd.indexOf(camera.getHandleOrd().toString()) > -1 || cameraOrd.indexOf(camera.getSlotPathOrd().toString()) > -1) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)camera.getDisplayName((Context)op)).w((Object)"</option>");
    }

    private BComponent[] getRemoteCameras(BComponent base) {
        Array ords = new Array(BOrd.class);
        BITable table = (BITable)BOrd.make((String)"bql: select slotPath from videoDriver:IVideoCamera").get((BObject)base);
        Column slotPathColumn = table.getColumns().get("slotPath");
        TableCursor cursor = table.cursor();
        while (cursor.next()) {
            ords.add((Object)BOrd.make((String)cursor.cell(slotPathColumn).toString()));
        }
        BatchResolve batch = new BatchResolve((BOrd[])ords.trim());
        batch.resolve((BObject)base);
        return batch.getTargetComponents();
    }

    public boolean process(HxOp op) throws Exception {
        return super.process(op);
    }

    public BObject save(HxOp op) throws Exception {
        BString b = (BString)op.get();
        String val = op.getFormValue("videoCamera");
        if (val.equals("none")) {
            return BString.DEFAULT;
        }
        return BString.make((String)val);
    }

    public class CameraChangedCommand
    extends SmartCommand {
        public CameraChangedCommand(BHxView view) {
            super(view, Lexicon.make((String)Sys.getModuleForClass(VideoCommand.class).getModuleName()));
        }

        public String getName(HxOp op) {
            return "cameraSelectionChanged";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String cameraOrd = op.getFormValue("videoCamera");
            if (!cameraOrd.equals("none")) {
                BComponent cameraObject = this.resolveCameraSelection(cameraOrd);
                if (cameraObject == null) {
                    return;
                }
                cameraObject.lease();
                String presetStr = op.getFormValue("cameraPreset");
                int presetVal = 1;
                if (presetStr != null) {
                    presetVal = Integer.parseInt(presetStr);
                }
                BEnumRange range = null;
                if (cameraObject.getType().is(BIRemoteVideoCamera.TYPE)) {
                    BComponent camera = this.resolveRemoteVideoPointToCamera((BIRemoteVideoCamera)cameraObject, op);
                    if (camera == null) {
                        throw new Exception("Unable to obtain presets for remote camera '" + cameraObject.getDisplayName((Context)op) + "'. The camera could not be resolved.");
                    }
                    range = (BEnumRange)camera.get("presetText");
                } else {
                    range = (BEnumRange)cameraObject.get("presetText");
                }
                BDynamicEnum presets = BDynamicEnum.make((int)presetVal, (BEnumRange)range);
                String cameraPresetS = SlotPath.escape((String)this.lex.getText("cameraPreset"));
                String videoEnabledS = SlotPath.escape((String)this.lex.getText("videoEnabled"));
                String path = op.getPath().substring(0, op.getPath().lastIndexOf(46)) + "." + cameraPresetS;
                String enabledPath = op.getPath().substring(0, op.getPath().lastIndexOf(46)) + "." + videoEnabledS;
                out.write("var elem = $$('" + path + ".value');");
                out.write("if (elem != null) {");
                out.write("select.clearSelect('" + path + ".value');");
                if (range == null) {
                    out.w((Object)"}");
                    throw new Exception("Unable to obtain the list of presets for camera " + cameraObject.getDisplayName((Context)op));
                }
                int[] ordinals = range.getOrdinals();
                for (int i = 0; i < ordinals.length; ++i) {
                    BEnum e = range.get(ordinals[i]);
                    out.write("select.addToSelect('" + path + ".value', '" + ordinals[i] + "','" + e.getDisplayTag((Context)op) + "');");
                }
                out.w((Object)"}");
            }
        }

        private BComponent resolveCameraSelection(String cameraOrd) {
            if (!cameraOrd.startsWith("station:")) {
                return (BComponent)BOrd.make((String)cameraOrd).resolve((BObject)Sys.getStation()).get();
            }
            String remoteStation = cameraOrd.substring(cameraOrd.indexOf(":") + 1, cameraOrd.indexOf("|"));
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(remoteStation);
            if (station != null) {
                String handleOrd = cameraOrd.substring(cameraOrd.indexOf("|") + 1);
                return RemoteUtil.getRemoteComponent((BFoxSession)RemoteUtil.getFoxSession((BNiagaraStation)station), (String)handleOrd);
            }
            return null;
        }

        private BComponent resolveRemoteVideoPointToCamera(BIRemoteVideoCamera cameraPoint, HxOp op) throws Exception {
            BNiagaraStation niagaraStation = cameraPoint.getNiagaraStation();
            if (niagaraStation.isDown() || niagaraStation.isFault() || niagaraStation.isDisabled()) {
                throw new Exception("Unable to obtain presets for remote camera. The status of the remote station \"" + niagaraStation.getStationName() + "\" is " + niagaraStation.getStatus());
            }
            BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)niagaraStation);
            return RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)cameraPoint.getRemoteVideoOrd().toString());
        }
    }
}

