/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;
import com.tridium.ddfHttp.comm.BDdfHttpTransmitter;
import com.tridium.ddfHttp.comm.DdfAuthenticationHelper;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpException;
import javax.baja.net.UrlConnection;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;

public class DdfHttpHelper {
    protected String mostRecentUrlString;
    protected String mostRecentRequestMethod = null;
    protected String mostRecentUrlAddress = null;
    String mostRecentUrlRightOfQuestionMark = null;
    protected String mostRecentUrlPostData = null;
    protected BIDdfRequest mostRecentDdfRequest;
    protected URL mostRecentJavaUrl = null;
    protected BDdfHttpCommunicator httpCommunicator = null;
    protected UrlConnection mostRecentBajaUrlConnection = null;
    protected boolean receiverReadyToReceive = false;
    protected boolean httpHelperStopped = false;
    protected BDdfHttpTransmitter ddfHttpTransmitter;
    protected LinkedList<UrlConnection> openHttpConnections = new LinkedList();
    protected IntHashMap authenticationHelpers = new IntHashMap();
    protected ConnectionWatchdogThread connectionWatchdogThread;
    public static final Lexicon LEX = Lexicon.make(DdfHttpHelper.class);

    public DdfHttpHelper(BDdfHttpTransmitter ddfHttpTransmitter) {
        this.ddfHttpTransmitter = ddfHttpTransmitter;
    }

    protected String getWatchdogThreadName() {
        String watchdogThreadName = "ConnectionWatchdog";
        String suffix = DdfHttpHelper.getThreadSuffix((BIDdfCommunicator)this.httpCommunicator);
        if (suffix != null && suffix.length() > 0) {
            watchdogThreadName = watchdogThreadName + ':' + suffix;
        }
        watchdogThreadName = watchdogThreadName + ':' + this.httpCommunicator.getHandle();
        return watchdogThreadName;
    }

    protected static String getThreadSuffix(BIDdfCommunicator ddfCommunicator) {
        if (ddfCommunicator instanceof BComplex) {
            if (((BComplex)ddfCommunicator).getParent() != null) {
                return ((BComplex)ddfCommunicator).getParent().getName();
            }
            return "";
        }
        return "";
    }

    public void stopHelping() {
        this.httpHelperStopped = true;
        this.cleanupListOfOutstandingUrlConnections();
    }

    protected void cleanupListOfOutstandingUrlConnections() {
        ListIterator i = this.openHttpConnections.listIterator();
        while (i.hasNext()) {
            UrlConnection potentiallyOpenUrlConnection = (UrlConnection)i.next();
            if (!potentiallyOpenUrlConnection.isOpen()) continue;
            potentiallyOpenUrlConnection.close();
        }
    }

    public synchronized void transmitWhenReadyToReceive(BIDdfRequest ddfRequest) throws Exception {
        block7: {
            if (this.httpHelperStopped) {
                throw new BajaRuntimeException("Ddf Http Helper Stopped");
            }
            if (!(ddfRequest instanceof BIDdfHttpStreamRequest) && !this.receiverReadyToReceive) {
                this.wait();
            }
            try {
                this.transmit(ddfRequest);
            }
            catch (IOException ioe) {
                int remainingRetries;
                this.ddfHttpTransmitter.getDdfCommunicator().getLog().error(ioe.toString());
                if (ddfRequest instanceof BIDdfHttpStreamRequest && (remainingRetries = ddfRequest.getRemainingRetryCount()) > 0) {
                    ddfRequest.setRemainingRetryCount(remainingRetries - 1);
                    this.ddfHttpTransmitter.setRetransmissionCount(this.ddfHttpTransmitter.getRetransmissionCount() + 1L);
                    this.transmitWhenReadyToReceive(ddfRequest);
                }
            }
            catch (IcmpPingFailure icmpPingFailure) {
                String httpTxType;
                String string = httpTxType = this.mostRecentUrlPostData == null ? "GET" : "POST";
                if (this.httpCommunicator.getLog().isTraceOn()) {
                    this.httpCommunicator.getLog().trace("HTTP " + httpTxType + " Failed - " + icmpPingFailure.getLocalizedMessage());
                }
                if (!(ddfRequest instanceof BValue)) break block7;
                this.httpCommunicator.getTransactionManager().checkOutstandingTimeout((BValue)ddfRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmit(BIDdfRequest ddfRequest) throws Exception {
        this.mostRecentDdfRequest = ddfRequest;
        this.httpCommunicator = this.ddfHttpTransmitter.getHttpCommunicator();
        this.parseJavaUrl();
        if (this.ddfHttpTransmitter.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace();
        }
        if (this.connectionWatchdogThread == null) {
            this.connectionWatchdogThread = new ConnectionWatchdogThread();
            this.connectionWatchdogThread.start();
        }
        this.transmitHttp();
        if (ddfRequest instanceof BIDdfHttpStreamRequest) {
            if (this.httpCommunicator.getLog().isTraceOn()) {
                this.httpCommunicator.getLog().trace("HTTP <Rx Stream>");
            }
            boolean shouldCloseAutomatically = true;
            try {
                shouldCloseAutomatically = ((BIDdfHttpStreamRequest)ddfRequest).processHttpStream(this.mostRecentBajaUrlConnection);
            }
            catch (Exception e) {
                this.httpCommunicator.getLog().error(LEX.getText("DriverUnableToProcessHttpStream"), (Throwable)e);
                shouldCloseAutomatically = true;
            }
            finally {
                if (shouldCloseAutomatically) {
                    this.mostRecentBajaUrlConnection.close();
                } else {
                    this.cleanupClosedOutstandingStreams();
                    this.openHttpConnections.add(this.mostRecentBajaUrlConnection);
                }
            }
        } else {
            this.notifyAll();
        }
    }

    protected void cleanupClosedOutstandingStreams() {
        ListIterator i = this.openHttpConnections.listIterator();
        while (i.hasNext()) {
            UrlConnection urlConnection = (UrlConnection)i.next();
            if (urlConnection.isOpen()) continue;
            i.remove();
        }
    }

    public synchronized byte[] waitReceiveNextAndClose() throws Exception, HttpException {
        try {
            if (this.httpHelperStopped) {
                throw new BajaRuntimeException("Ddf Http Helper Stopped");
            }
            this.receiverReadyToReceive = true;
            this.notifyAll();
            this.wait();
            byte[] byArray = this.readContentAndClose();
            return byArray;
        }
        finally {
            this.receiverReadyToReceive = false;
        }
    }

    protected byte[] readContent() throws Exception {
        return this.mostRecentBajaUrlConnection.readContent();
    }

    public byte[] readContentAndClose() throws Exception, HttpException {
        this.verifyOk();
        byte[] content = this.readContent();
        this.closeConnection();
        return content;
    }

    protected void closeConnection() {
        this.mostRecentBajaUrlConnection.close();
    }

    protected void makeConnection() throws Exception {
        try {
            Sys.getService((Type)BTcpIpPlatformService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.mostRecentBajaUrlConnection = new UrlConnection(this.mostRecentJavaUrl);
        this.mostRecentBajaUrlConnection.setTimeout(this.httpCommunicator.getSoTimeout(this.mostRecentDdfRequest));
    }

    protected int doGetOrPost() throws Exception {
        if (this.mostRecentRequestMethod.equals("GET")) {
            return this.mostRecentBajaUrlConnection.connect();
        }
        return this.mostRecentBajaUrlConnection.post(this.mostRecentUrlAddress, this.httpCommunicator.getHttpContentType(this.mostRecentDdfRequest), this.mostRecentUrlPostData.getBytes());
    }

    protected void transmitHttp() throws Exception {
        this.makeConnection();
        this.considerPreAuthentication();
        int statusCode = this.doGetOrPost();
        this.reviewStatusCode(statusCode);
    }

    protected void reviewStatusCode(int statusCode) throws Exception {
        if (statusCode == 401) {
            this.addAuthenticationBasedOnHttpResponse();
            this.doGetOrPost();
        }
    }

    protected void verifyOk() throws HttpException {
        this.mostRecentBajaUrlConnection.checkOk();
    }

    protected BUsernameAndPassword getUserNameAndPasswordForTransaction() {
        return (BUsernameAndPassword)this.ddfHttpTransmitter.getHttpCommunicator().getHttpCredentials(this.mostRecentDdfRequest);
    }

    protected DdfAuthenticationHelper makeAuthenticationHelper(BUsernameAndPassword credentials) {
        return new DdfAuthenticationHelper(this.mostRecentJavaUrl, credentials, this.mostRecentBajaUrlConnection);
    }

    protected void addAuthenticationBasedOnHttpResponse() throws Exception {
        BUsernameAndPassword credentials = this.getUserNameAndPasswordForTransaction();
        DdfAuthenticationHelper authenticationHelper = this.makeAuthenticationHelper(credentials);
        this.authenticationHelpers.put(this.computeHashCodeForAuthenticationHelper(this.mostRecentJavaUrl, credentials), (Object)authenticationHelper);
        if (this.mostRecentBajaUrlConnection.shouldClose()) {
            this.mostRecentBajaUrlConnection.close();
            this.makeConnection();
        }
        authenticationHelper.addRequestAuthorization((HttpConnection)this.mostRecentBajaUrlConnection);
    }

    protected int computeHashCodeForAuthenticationHelper(URL javaUrl, BUsernameAndPassword credentials) {
        String obj = new String(this.mostRecentUrlRightOfQuestionMark + ':' + credentials.getUsername() + ':' + AccessController.doPrivileged(() -> ((BPassword)credentials.getPassword()).getValue()));
        return obj.hashCode();
    }

    protected void considerPreAuthentication() throws Exception {
        BUsernameAndPassword credentials = (BUsernameAndPassword)this.ddfHttpTransmitter.getHttpCommunicator().getHttpCredentials(this.mostRecentDdfRequest);
        int helperCode = this.computeHashCodeForAuthenticationHelper(this.mostRecentJavaUrl, credentials);
        DdfAuthenticationHelper authenticationHelper = (DdfAuthenticationHelper)this.authenticationHelpers.get(helperCode);
        if (authenticationHelper != null) {
            authenticationHelper.addRequestAuthorization((HttpConnection)this.mostRecentBajaUrlConnection);
        }
    }

    protected void parseJavaUrl() throws MalformedURLException {
        this.parseUrlString();
        this.parseRequestMethod();
        this.parseAddressAndData();
        this.mostRecentJavaUrl = new URL(this.mostRecentUrlAddress);
    }

    protected void trace() {
        StringBuffer buf = new StringBuffer("HTTP ");
        if (this.mostRecentUrlPostData == null) {
            buf.append("GET ");
        } else {
            buf.append("POST");
        }
        buf.append(this.mostRecentUrlString);
        this.httpCommunicator.getLog().trace(buf.toString());
    }

    protected void parseUrlString() {
        this.mostRecentUrlString = new String(this.mostRecentDdfRequest.toByteArray());
    }

    protected void parseRequestMethod() {
        int indexOfSpace = this.mostRecentUrlString.indexOf(32);
        this.mostRecentRequestMethod = indexOfSpace >= 0 ? this.mostRecentUrlString.substring(0, indexOfSpace).trim().toUpperCase() : "GET";
    }

    protected void parseAddressAndData() {
        int urlIndexOfSpace = this.mostRecentUrlString.indexOf(" ");
        int urlIndexOfQuestionMark = this.mostRecentUrlString.indexOf("?");
        if (urlIndexOfSpace < 0) {
            urlIndexOfSpace = 0;
        }
        if (urlIndexOfQuestionMark >= 0 && !this.mostRecentRequestMethod.equals("GET")) {
            this.mostRecentUrlRightOfQuestionMark = this.mostRecentUrlAddress = this.mostRecentUrlString.substring(urlIndexOfSpace + 1, urlIndexOfQuestionMark);
            this.mostRecentUrlPostData = this.mostRecentUrlString.substring(urlIndexOfQuestionMark + 1);
        } else {
            this.mostRecentUrlAddress = this.mostRecentUrlString.substring(urlIndexOfSpace);
            this.mostRecentUrlRightOfQuestionMark = urlIndexOfQuestionMark >= 0 ? this.mostRecentUrlString.substring(urlIndexOfSpace, urlIndexOfQuestionMark) : this.mostRecentUrlAddress;
            this.mostRecentUrlPostData = null;
        }
    }

    public class ConnectionWatchdogThread
    extends Thread {
        public Queue watchdogQ;
        public boolean isAlive;

        public ConnectionWatchdogThread() {
            super(DdfHttpHelper.this.getWatchdogThreadName());
            this.watchdogQ = new Queue();
        }

        public void stopWatchdog() {
            this.isAlive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            this.isAlive = true;
            while (this.isAlive) {
                try {
                    Runnable work = this.watchdogQ.todo(500);
                    this.process(work);
                }
                catch (InterruptedException work) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        protected void process(Runnable work) throws Exception {
            if (work != null) {
                work.run();
            }
        }
    }

    public class PreemptConnectionAfterTimeout
    implements Runnable {
        public long interval;
        public volatile boolean needToPreEmptUponWake = true;

        public PreemptConnectionAfterTimeout(BIDdfRequest ddfRequest) {
            this.interval = DdfHttpHelper.this.httpCommunicator.getSoTimeout(ddfRequest);
            if (this.interval <= 0L) {
                this.interval = DdfHttpHelper.this.httpCommunicator.getHttpReceiver().getResponseTimeout().getMillis();
            }
        }

        @Override
        public synchronized void run() {
            try {
                if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                    DdfHttpHelper.this.httpCommunicator.getLog().trace("Countdown to pre-empt in " + this.interval + " millis.");
                }
                this.wait(this.interval);
                if (this.needToPreEmptUponWake && DdfHttpHelper.this.mostRecentBajaUrlConnection != null) {
                    if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                        DdfHttpHelper.this.httpCommunicator.getLog().trace("Pre-empting HTTP connection.");
                    }
                    DdfHttpHelper.this.mostRecentBajaUrlConnection.close();
                } else if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                    DdfHttpHelper.this.httpCommunicator.getLog().trace("No need to pre-empt HTTP connection.");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void cancelPreemptionCountdown() {
            this.needToPreEmptUponWake = false;
            this.notifyAll();
        }

        public void beginPreemptionCountdown() {
            DdfHttpHelper.this.connectionWatchdogThread.watchdogQ.enqueue((Object)this);
        }
    }

    public class IcmpPingFailure
    extends Exception {
        public IcmpPingFailure(String localizedMessage) {
            super(localizedMessage);
        }
    }
}

