/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.UrlConnection;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;

public class DdfAuthenticationHelper {
    protected static SecureRandom clientRandom = new SecureRandom();
    protected int nc = 0;
    protected BIpHost webHost = null;
    protected int webPort = 80;
    protected BUsernameAndPassword webUsernameAndPassword = null;
    protected String webAuthenticateHeader = null;
    protected String webUri = null;

    public DdfAuthenticationHelper(URL javaUrl, BUsernameAndPassword webUsernameAndPassword, UrlConnection httpReplyRequestingAuth) {
        this.webHost = new BIpHost(javaUrl.getHost());
        this.webPort = javaUrl.getPort() == -1 ? 80 : javaUrl.getPort();
        this.webUsernameAndPassword = webUsernameAndPassword;
        this.webAuthenticateHeader = httpReplyRequestingAuth.getResponseHeader("WWW-Authenticate");
        this.webUri = javaUrl.getFile();
    }

    public boolean isDigestAuthentication() throws Exception {
        return this.getAuthenticationType(this.webAuthenticateHeader).equalsIgnoreCase("digest");
    }

    public boolean isBasicAuthentication() throws Exception {
        return this.getAuthenticationType(this.webAuthenticateHeader).equalsIgnoreCase("basic");
    }

    public String getAuthenticationType(String webAuthenticateHeader) throws Exception {
        Pattern p = Pattern.compile("\\s*(\\S*)", 2);
        Matcher oroMatcher = p.matcher(webAuthenticateHeader);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(1);
        }
        return null;
    }

    public boolean addRequestAuthorization(HttpConnection httpRequestConn) throws Exception {
        if (this.isDigestAuthentication()) {
            return this.addDigestAuthorization(httpRequestConn);
        }
        if (this.isBasicAuthentication()) {
            return this.addBasicAuthorization(httpRequestConn);
        }
        return false;
    }

    public boolean addBasicAuthorization(HttpConnection httpRequestConn) {
        if (this.webUsernameAndPassword == null) {
            return false;
        }
        String basicAuthorizationCredentials = this.webUsernameAndPassword.getUsername() + ":" + AccessController.doPrivileged(() -> ((BPassword)this.webUsernameAndPassword.getPassword()).getValue());
        String authorization = new String(Base64.getEncoder().encode(basicAuthorizationCredentials.getBytes()));
        httpRequestConn.setRequestHeader("Authorization", "Basic " + authorization);
        return true;
    }

    public boolean addDigestAuthorization(HttpConnection httpRequestConn) throws Exception {
        if (this.webAuthenticateHeader == null) {
            return false;
        }
        String realm = this.getValue("realm", this.webAuthenticateHeader);
        String nonce = this.getValue("nonce", this.webAuthenticateHeader);
        String qop = this.getValue("qop", this.webAuthenticateHeader);
        if (nonce == null || this.webUsernameAndPassword == null) {
            return false;
        }
        ++this.nc;
        String cnonce = this.getCnonce();
        StringBuffer response = new StringBuffer();
        response.append("Digest username=").append(DdfAuthenticationHelper.quote(this.webUsernameAndPassword.getUsername())).append(", ");
        response.append("realm=").append(DdfAuthenticationHelper.quote(realm)).append(", ");
        response.append("nonce=").append(DdfAuthenticationHelper.quote(nonce)).append(", ");
        response.append("uri=").append(DdfAuthenticationHelper.quote(this.webUri)).append(", ");
        response.append("nc=").append(this.nc).append(", ");
        response.append("qop=").append(DdfAuthenticationHelper.unquote(qop)).append(", ");
        response.append("cnonce=\"").append(cnonce).append("\", ");
        response.append("response=\"");
        response.append(this.hexMD5(this.hexMD5(DdfAuthenticationHelper.unquote(this.webUsernameAndPassword.getUsername()) + ':' + DdfAuthenticationHelper.unquote(realm) + ':' + AccessController.doPrivileged(() -> ((BPassword)this.webUsernameAndPassword.getPassword()).getValue())) + ':' + DdfAuthenticationHelper.unquote(nonce) + ':' + this.nc + ':' + cnonce + ':' + DdfAuthenticationHelper.unquote(qop) + ':' + this.hexMD5(httpRequestConn.getRequestMethod() + ":" + this.webUri)));
        response.append("\"");
        httpRequestConn.setRequestHeader("Authorization", response.toString());
        return true;
    }

    protected String getCnonce() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        out.writeUTF("cnonce");
        out.writeInt(this.nc);
        out.writeUTF(this.webHost.getHostname());
        out.writeInt(this.webPort);
        out.writeLong(System.currentTimeMillis());
        out.writeInt(clientRandom.nextInt());
        return this.hexMD5(new String(bout.toByteArray()));
    }

    protected String hexMD5(String in) throws Exception {
        StringBuffer result = new StringBuffer();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] toHash = md5.digest(in.getBytes());
        for (int i = 0; i < toHash.length; ++i) {
            result.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)toHash[i])));
        }
        return result.toString();
    }

    protected String getValue(String key, String textToSearch) throws Exception {
        if (textToSearch != null) {
            String quotedMatch = this.getInQuotes(key, textToSearch);
            if (quotedMatch == null) {
                return this.getNotInQuotes(key, textToSearch);
            }
            return quotedMatch;
        }
        return null;
    }

    protected String getInQuotes(String key, String textToSearch) throws Exception {
        Pattern p = Pattern.compile("\\b" + key + "\\s*=\\s*\"(.*?)\"", 2);
        Matcher oroMatcher = p.matcher(textToSearch);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(1);
        }
        return null;
    }

    protected String getNotInQuotes(String key, String textToSearch) throws Exception {
        Pattern p = Pattern.compile("\\b" + key + "\\s*=\\s*([^\\s,]*)", 2);
        Matcher oroMatcher = p.matcher(textToSearch);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(1);
        }
        return null;
    }

    protected static String quote(String in) {
        if (in.length() == 0) {
            return "\"\"";
        }
        if (in.charAt(0) == '\"') {
            return in;
        }
        return '\"' + in + '\"';
    }

    protected static String unquote(String in) {
        if (in.length() == 0) {
            return in;
        }
        StringBuffer result = new StringBuffer(in);
        if (result.charAt(0) == '\"') {
            result.deleteCharAt(0);
        }
        if (result.charAt(result.length() - 1) == '\"') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

