/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BJaceSlaBattery;
import com.tridium.platPower.BNpm2NimhBattery;
import com.tridium.platPower.BPowerMonitorPlatformService;
import com.tridium.platPower.PowerdQnx;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPowerMonitorPlatformServiceQnx
extends BPowerMonitorPlatformService {
    public static final Type TYPE = Sys.loadType(BPowerMonitorPlatformServiceQnx.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    @Override
    protected void loadLibraries() {
        log.fine("Loading libPower.so...");
        PowerdQnx.loadLibraries();
        PowerdQnx.open();
    }

    @Override
    public BBattery getBatteryInstance() {
        return AccessController.doPrivileged(() -> {
            String type = null;
            if (!new File("/dev/powerd/batteryType").exists()) return new BJaceSlaBattery();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader("/dev/powerd/batteryType"));){
                type = bufferedReader.readLine();
                if (type != null) {
                    if ((type = type.trim()).equals("NiMH")) {
                        BNpm2NimhBattery bNpm2NimhBattery = new BNpm2NimhBattery();
                        return bNpm2NimhBattery;
                    }
                    BJaceSlaBattery bJaceSlaBattery = new BJaceSlaBattery();
                    return bJaceSlaBattery;
                }
                log.log(Level.WARNING, "/dev/powerd/batteryType was empty");
                return new BJaceSlaBattery();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to read batteryType", e);
            }
            return new BJaceSlaBattery();
        });
    }

    @Override
    public boolean isPrimaryPresent() {
        return PowerdQnx.isPrimaryPresent();
    }
}

