/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.qnx.BSystemPlatformServiceQnxLegacy;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BBattery
extends BComponent {
    public static final Action getShutdownDelayFacets = BBattery.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBattery.class);
    private static final BFacets shutdownDelayFacets = BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)});
    public static Logger log = Logger.getLogger("power");
    protected boolean nativesLoaded = false;

    public BFacets getShutdownDelayFacets() {
        return (BFacets)this.invoke(getShutdownDelayFacets, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                BPlatform.log.fine("Loading power native library");
                System.loadLibrary("power");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                BPlatform.log.log(Level.SEVERE, "Cannot load power native library", e);
            }
            return this.nativesLoaded;
        });
    }

    protected boolean isBatteryPresent() {
        try {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (sysService instanceof BSystemPlatformServiceQnxLegacy) {
                BSystemPlatformServiceQnxLegacy sysServiceQnx = (BSystemPlatformServiceQnxLegacy)sysService;
                sysServiceQnx.checkPropertiesLoaded();
                if (!sysServiceQnx.getIsBatteryPresent()) {
                    return false;
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return true;
    }

    public abstract boolean isBatteryGood();

    public abstract BAbsTime getTestTime();

    public abstract BRelTime validateShutdownDelay(BRelTime var1);

    public abstract void refresh();

    public BFacets doGetShutdownDelayFacets() {
        return shutdownDelayFacets;
    }
}

