/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.ping;

import com.tridium.sms.ping.BIBasicPingMonitorParent;
import com.tridium.sms.ping.BIPingable;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBasicPingMonitor
extends BComponent {
    public static final Property pingEnabled = BBasicPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property pingFrequency = BBasicPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    public static final Action ping = BBasicPingMonitor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBasicPingMonitor.class);
    private Vector<BIPingable> pingables = new Vector();
    private Clock.Ticket ticket = null;
    private static final BIcon icon = BIcon.std((String)"monitor.png");

    public boolean getPingEnabled() {
        return this.getBoolean(pingEnabled);
    }

    public void setPingEnabled(boolean v) {
        this.setBoolean(pingEnabled, v, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime v) {
        this.set(pingFrequency, (BValue)v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() {
        this.restartTimer();
    }

    public void stopped() {
        this.stopTimer();
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && (p == pingEnabled || p == pingFrequency)) {
            this.restartTimer();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIBasicPingMonitorParent;
    }

    private BIBasicPingMonitorParent getMonitorParent() {
        return (BIBasicPingMonitorParent)this.getParent();
    }

    public BIcon getIcon() {
        return icon;
    }

    private void restartTimer() {
        this.stopTimer();
        if (this.getPingEnabled()) {
            this.ping();
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)ping, null);
        }
    }

    private void stopTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    public void doPing() {
        if (!this.getMonitorParent().isDisabled() || !this.getMonitorParent().isFatalFault()) {
            Enumeration<BIPingable> e = this.pingables.elements();
            while (e.hasMoreElements()) {
                BIPingable p = e.nextElement();
                p.ping();
            }
        }
    }

    public void addPingable(BIPingable p) {
        this.pingables.add(p);
    }

    public void removePingable(BIPingable p) {
        this.pingables.remove(p);
    }
}

