/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.gprs;

import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;

class GprsCommTransaction {
    private String needle = "";
    private String haystack = "";
    private boolean completed = false;
    private static final int WAIT_PERIOD = 200;

    GprsCommTransaction(String requestStr) {
        this.needle = requestStr;
    }

    synchronized boolean check(String hay) {
        boolean res = false;
        if (hay != null) {
            this.haystack = this.haystack + hay;
            if (!this.completed && this.haystack.toLowerCase().indexOf(this.needle.toLowerCase()) > -1) {
                this.completed = true;
                this.notify();
                res = true;
            }
        }
        return res;
    }

    synchronized String getRecStr() {
        return this.haystack;
    }

    synchronized boolean isCompleted() {
        return this.completed;
    }

    synchronized int waitForTransaction() {
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            SmsToolkit.log.log(Level.SEVERE, "Waiting for CommTransaction to complete", e);
        }
        return 200;
    }
}

