/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.alarm;

import com.tridium.alarm.ack.BAlarmAcknowledger;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public final class BSmsAlarmAcknowledger
extends BAlarmAcknowledger {
    public static final Property lastSmsMessageReceived = BSmsAlarmAcknowledger.newProperty((int)67, (BValue)new BSmsMessage(), null);
    public static final Action received = BSmsAlarmAcknowledger.newAction((int)24, (BValue)new BSmsMessage(), null);
    public static final Type TYPE = Sys.loadType(BSmsAlarmAcknowledger.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.make((String)"module://sms/res/sms.png"), (BIcon)BIcon.std((String)"badges/new.png"));

    public BSmsMessage getLastSmsMessageReceived() {
        return (BSmsMessage)this.get(lastSmsMessageReceived);
    }

    public void setLastSmsMessageReceived(BSmsMessage v) {
        this.set(lastSmsMessageReceived, (BValue)v, null);
    }

    public void received(BSmsMessage message) {
        this.invoke(received, (BValue)message, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == received) {
            this.post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doReceived(BSmsMessage message) {
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Processing received sms: " + message.getPhoneNumbers());
        }
        this.incTotalMessagesReceivedToday();
        this.getLastSmsMessageReceived().copyFrom((BComplex)message);
        String subStr = message.getMessage();
        int uuidIndex = subStr.toUpperCase().indexOf("UUID:");
        if (uuidIndex <= -1) {
            this.doFail("Could not find UUID in SMS Message to ack alarm");
            return;
        }
        String phoneNumber = message.getPhoneNumbers();
        String userName = null;
        try {
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser[] users = (BUser[])userService.getChildren(BUser.class);
            for (int i = 0; i < users.length; ++i) {
                String userPhoneNumber = SmsToolkit.removeSpaceCharacters(users[i].getCellPhoneNumber());
                if (!userPhoneNumber.equals(phoneNumber) && !BSmsAlarmAcknowledger.removePlus(userPhoneNumber).equals(BSmsAlarmAcknowledger.removePlus(phoneNumber))) continue;
                userName = users[i].getName();
                break;
            }
        }
        catch (ServiceNotFoundException e) {
            String msg = "Unable to find User Service";
            log.log(Level.SEVERE, msg, e);
            this.doFail(msg);
            return;
        }
        if (userName == null) {
            this.doFail("Non user attempted to ack alarm via sms: " + phoneNumber);
            return;
        }
        try {
            String uuidStr = subStr.substring(uuidIndex + "UUID:".length(), uuidIndex + 36 + "UUID:".length());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Recieved alarm ack sms: " + uuidStr + " user: " + userName);
            }
            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(uuidStr);
            this.ackAlarm(uuid, userName);
        }
        catch (Exception e) {
            String msg = "Could not decode UUID from received SMS Message";
            log.log(Level.SEVERE, msg, e);
            this.doFail(msg);
        }
    }

    private static String removePlus(String s) {
        if (s.length() > 0 && s.charAt(0) == '+') {
            return s.substring(1, s.length());
        }
        return s;
    }
}

