/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BAbstractSmsTransport;
import com.tridium.sms.BSmsElement;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.SmsException;
import com.tridium.sms.ping.BBasicPingMonitor;
import com.tridium.sms.ping.BIBasicPingMonitorParent;
import com.tridium.sms.ping.BIPingable;
import com.tridium.sms.serial.BSerialSmsTransport;
import com.tridium.sms.util.BSmsWorker;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public final class BSmsService
extends BAbstractService
implements BIPingable,
BIBasicPingMonitorParent {
    public static final Property worker = BSmsService.newProperty((int)4, (BValue)new BSmsWorker(), null);
    public static final Property transportType = BSmsService.newProperty((int)0, (BValue)BTypeSpec.make((String)"sms:SerialSmsTransport"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"sms:AbstractSmsTransport")));
    public static final Property transport = BSmsService.newProperty((int)0, (BValue)new BSerialSmsTransport(), null);
    public static final Property monitor = BSmsService.newProperty((int)0, (BValue)new BBasicPingMonitor(), null);
    public static final Property signalStrength = BSmsService.newProperty((int)1, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:SignalStrengthFE")));
    public static final Property maxQueueSize = BSmsService.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property queueSize = BSmsService.newProperty((int)3, (int)0, null);
    public static final Property processQueueInterval = BSmsService.newProperty((int)0, (BValue)BRelTime.make((long)90000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)3000L)));
    public static final Property maxSendablePerDay = BSmsService.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberSentToday = BSmsService.newProperty((int)3, (int)0, null);
    public static final Property lastMessageSentTime = BSmsService.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property useEscapeCharacters = BSmsService.newProperty((int)0, (boolean)true, null);
    public static final Property readMessagesInterval = BSmsService.newProperty((int)0, (BValue)BRelTime.make((long)75000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)2000L)));
    public static final Action ping = BSmsService.newAction((int)16, null);
    public static final Action send = BSmsService.newAction((int)0, (BValue)new BSmsMessage(), null);
    public static final Action clearQueue = BSmsService.newAction((int)128, null);
    public static final Action processQueue = BSmsService.newAction((int)16, null);
    public static final Action resetNumberSentToday = BSmsService.newAction((int)128, null);
    public static final Action readMessages = BSmsService.newAction((int)16, null);
    public static final Topic received = BSmsService.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BSmsService.class);
    public static final String DEFAULT = "default";
    private static final BIcon icon = BIcon.make((String)"module://sms/res/smsService.png");
    private static Type[] serviceTypes = new Type[]{TYPE};
    private Clock.Ticket resetTicket = null;
    private Clock.Ticket processQueueTicket = null;
    private Clock.Ticket readMessagesTicket = null;

    public BSmsWorker getWorker() {
        return (BSmsWorker)this.get(worker);
    }

    public void setWorker(BSmsWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public BTypeSpec getTransportType() {
        return (BTypeSpec)this.get(transportType);
    }

    public void setTransportType(BTypeSpec v) {
        this.set(transportType, (BValue)v, null);
    }

    public BAbstractSmsTransport getTransport() {
        return (BAbstractSmsTransport)this.get(transport);
    }

    public void setTransport(BAbstractSmsTransport v) {
        this.set(transport, (BValue)v, null);
    }

    public BBasicPingMonitor getMonitor() {
        return (BBasicPingMonitor)this.get(monitor);
    }

    public void setMonitor(BBasicPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    public BStatusNumeric getSignalStrength() {
        return (BStatusNumeric)this.get(signalStrength);
    }

    public void setSignalStrength(BStatusNumeric v) {
        this.set(signalStrength, (BValue)v, null);
    }

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    public BRelTime getProcessQueueInterval() {
        return (BRelTime)this.get(processQueueInterval);
    }

    public void setProcessQueueInterval(BRelTime v) {
        this.set(processQueueInterval, (BValue)v, null);
    }

    public int getMaxSendablePerDay() {
        return this.getInt(maxSendablePerDay);
    }

    public void setMaxSendablePerDay(int v) {
        this.setInt(maxSendablePerDay, v, null);
    }

    public int getNumberSentToday() {
        return this.getInt(numberSentToday);
    }

    public void setNumberSentToday(int v) {
        this.setInt(numberSentToday, v, null);
    }

    public BAbsTime getLastMessageSentTime() {
        return (BAbsTime)this.get(lastMessageSentTime);
    }

    public void setLastMessageSentTime(BAbsTime v) {
        this.set(lastMessageSentTime, (BValue)v, null);
    }

    public boolean getUseEscapeCharacters() {
        return this.getBoolean(useEscapeCharacters);
    }

    public void setUseEscapeCharacters(boolean v) {
        this.setBoolean(useEscapeCharacters, v, null);
    }

    public BRelTime getReadMessagesInterval() {
        return (BRelTime)this.get(readMessagesInterval);
    }

    public void setReadMessagesInterval(BRelTime v) {
        this.set(readMessagesInterval, (BValue)v, null);
    }

    @Override
    public void ping() {
        this.invoke(ping, null, null);
    }

    public void send(BSmsMessage msg) {
        this.invoke(send, (BValue)msg, null);
    }

    public void clearQueue() {
        this.invoke(clearQueue, null, null);
    }

    public void processQueue() {
        this.invoke(processQueue, null, null);
    }

    public void resetNumberSentToday() {
        this.invoke(resetNumberSentToday, null, null);
    }

    public void readMessages() {
        this.invoke(readMessages, null, null);
    }

    public void fireReceived(BSmsMessage event) {
        this.fire(received, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        BSmsElement[] msgs = (BSmsElement[])this.getChildren(BSmsElement.class);
        this.setQueueSize(msgs.length);
    }

    public void serviceStopped() throws Exception {
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "sms");
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        for (int i = 0; i < kids.length; ++i) {
            BComplex kid;
            if (kids[i].asObject().isComplex() && (kid = (BComplex)kids[i]).getPropertyInParent().isFrozen()) continue;
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public void stationStarted() throws Exception {
        this.init();
    }

    private final void init() {
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("*** Starting Sms Service ***");
        }
        this.checkTransportType();
        this.setQueueSize(((BSmsElement[])this.getChildren(BSmsElement.class)).length);
        this.getMonitor().addPingable(this);
        this.restartResetTimer();
    }

    public void stopped() {
        this.stopProcessQueueTimer();
        this.stopReadMessagesTimer();
        this.stopResetTimer();
        this.getMonitor().removePingable(this);
    }

    public void added(Property prop, Context cx) {
        if (this.isRunning() && prop.getType().equals(BSmsElement.TYPE)) {
            BSmsElement e = (BSmsElement)this.get(prop);
            e.setAdded(BAbsTime.now());
            this.incrementQueue();
            this.checkQueueSize();
            this.processQueue();
            if (this.isDisabled()) {
                SmsToolkit.log.warning("SMS Message added to disabled SMS Service!");
            }
        }
    }

    public void removed(Property prop, BValue oldValue, Context context) {
        if (this.isRunning() && oldValue instanceof BSmsElement) {
            this.decrementQueue();
        }
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning()) {
            if (prop.equals(maxQueueSize)) {
                this.checkQueueSize();
            } else if (prop.equals(transportType) || prop.equals(transport)) {
                this.checkTransportType();
            } else if (prop.equals(enabled)) {
                if (this.getEnabled()) {
                    this.ping();
                    this.processQueue();
                }
            } else if (prop.equals(processQueueInterval)) {
                this.restartProcessQueueTimer();
            } else if (prop.equals(readMessagesInterval)) {
                this.restartReadMessagesTimer();
            } else if (prop.equals(monitor)) {
                this.ping();
            }
        }
    }

    private void checkTransportType() {
        if (!this.getTransportType().getResolvedType().equals(this.getTransport().getType())) {
            this.setTransport((BAbstractSmsTransport)this.getTransportType().getInstance());
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void clockChanged(BRelTime shift) {
        this.restartResetTimer();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void atSteadyState() {
        this.restartProcessQueueTimer();
        this.restartReadMessagesTimer();
    }

    public static BSmsService getService() {
        return (BSmsService)Sys.getService((Type)TYPE);
    }

    private synchronized void incrementQueue() {
        this.setQueueSize(this.getQueueSize() + 1);
    }

    private synchronized void decrementQueue() {
        this.setQueueSize(this.getQueueSize() - 1);
    }

    public void doSend(BSmsMessage msg) {
        BSmsMessage newMsg = (BSmsMessage)msg.newCopy();
        BSmsElement e = new BSmsElement(newMsg);
        this.add("sms?", (BValue)e, 2053);
    }

    private void checkQueueSize() {
        if (this.getQueueSize() > this.getMaxQueueSize()) {
            int excess = this.getQueueSize() - this.getMaxQueueSize();
            for (int i = 0; i < excess; ++i) {
                this.removeFirstElement();
            }
        }
    }

    private void removeFirstElement() {
        BSmsElement[] elements = (BSmsElement[])this.getChildren(BSmsElement.class);
        if (elements != null && elements.length > 0) {
            this.remove((BComplex)elements[0]);
            StringBuffer buff = new StringBuffer();
            buff.append("Max SMS Message Queue size exceeded! Removing message from queue: ");
            buff.append(elements[0].getMessage().getPhoneNumbers());
            buff.append(" - ");
            buff.append(elements[0].getMessage().getMessage());
            SmsToolkit.log.warning(buff.toString());
        }
    }

    public void doClearQueue() {
        BSmsElement[] elements = (BSmsElement[])this.getChildren(BSmsElement.class);
        for (int i = 0; i < elements.length; ++i) {
            this.remove((BComplex)elements[i]);
        }
    }

    public void doResetNumberSentToday() {
        this.setNumberSentToday(0);
        this.restartResetTimer();
        this.processQueue();
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("Reset number of text messages sent today");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessQueue() {
        block15: {
            try {
                if (!this.isRunning()) {
                    return;
                }
                BSmsElement[] elements = null;
                if (this.isDisabled() || this.isFatalFault() || this.isDown() || !this.getTransport().isCommsActive()) break block15;
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("Processing sms queue");
                }
                elements = (BSmsElement[])this.getChildren(BSmsElement.class);
                for (int i = 0; i < elements.length; ++i) {
                    if (this.getNumberSentToday() >= this.getMaxSendablePerDay()) {
                        break;
                    }
                    try {
                        if (elements[i].getMessage().send()) {
                            this.remove((BComplex)elements[i]);
                        }
                        this.configOk();
                        if (this.getNumberSentToday() >= this.getMaxSendablePerDay()) {
                            SmsToolkit.log.warning("Cannot send anymore SMS text messages for today. Exceeded day limit!");
                        }
                        if (!this.isDisabled() && !this.isFatalFault()) {
                            if (this.isRunning()) continue;
                        }
                        break;
                    }
                    catch (Exception e) {
                        try {
                            elements[i].setSendAttempts(elements[i].getSendAttempts() + 1);
                            SmsToolkit.log.log(Level.SEVERE, "Sending SMS message", e);
                            this.configFail(e.getMessage());
                            continue;
                        }
                        catch (Exception e2) {
                            SmsToolkit.log.log(Level.SEVERE, "Fatal error sending SMS message", e);
                        }
                    }
                }
            }
            finally {
                this.restartProcessQueueTimer();
            }
        }
    }

    public void doReadMessages() {
        if (!this.isDisabled() && !this.isFatalFault() && !this.isDown() && this.getTransport().isCommsActive()) {
            try {
                BSmsMessage[] msgs = this.getTransport().readMessages();
                if (msgs != null) {
                    for (int i = 0; i < msgs.length; ++i) {
                        this.fireReceived(msgs[i]);
                    }
                    this.pingOk();
                }
            }
            catch (SmsException e) {
                this.pingFail(e.getMessage());
            }
        }
    }

    public void doPing() {
        if (!this.isDisabled() && !this.isFatalFault() && this.getMonitor().getPingEnabled() && this.getTransport().isCommsActive()) {
            try {
                this.getTransport().ping();
                this.pingOk();
            }
            catch (SmsException e) {
                this.pingFail(e.getMessage());
            }
            if (!this.isDown()) {
                BStatusNumeric n = new BStatusNumeric(0.0);
                try {
                    n = new BStatusNumeric(this.getTransport().getSignalStrength());
                    if (n.getValue() <= 0.0 && this.getSignalStrength().getValue() > 0.0) {
                        SmsToolkit.log.warning("Low signal strength detected!");
                    }
                    this.pingOk();
                }
                catch (SmsException e) {
                    this.pingFail(e.getMessage());
                }
                this.setSignalStrength(n);
            } else {
                this.setSignalStrength(new BStatusNumeric(0.0));
            }
        } else {
            this.setSignalStrength(new BStatusNumeric(0.0));
        }
    }

    public void pingOk() {
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
    }

    public void pingFail(String msg) {
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
    }

    public boolean isDown() {
        return this.getStatus().isDown();
    }

    private void restartReadMessagesTimer() {
        this.stopReadMessagesTimer();
        this.readMessagesTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getReadMessagesInterval(), (Action)readMessages, null);
    }

    private void stopReadMessagesTimer() {
        if (this.readMessagesTicket != null) {
            this.readMessagesTicket.cancel();
            this.readMessagesTicket = null;
        }
    }

    private void restartProcessQueueTimer() {
        this.stopProcessQueueTimer();
        this.processQueueTicket = Clock.schedule((BComponent)this, (BRelTime)this.getProcessQueueInterval(), (Action)processQueue, null);
    }

    private void stopProcessQueueTimer() {
        if (this.processQueueTicket != null) {
            this.processQueueTicket.cancel();
            this.processQueueTicket = null;
        }
    }

    private void restartResetTimer() {
        this.stopResetTimer();
        BAbsTime now = BAbsTime.now();
        BAbsTime next = now.nextDay();
        BAbsTime midnight = next.timeOfDay(0, 0, 0, 0);
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)midnight, (Action)resetNumberSentToday, null);
    }

    private void stopResetTimer() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(true);
        out.trTitle((Object)"SMS Outstanding Message Queue", 5);
        out.w((Object)"<tr>");
        out.th((Object)"Name");
        out.th((Object)"Added");
        out.th((Object)"Send Attempts");
        out.th((Object)"Phone Numbers");
        out.th((Object)"Message");
        out.w((Object)"</tr>");
        BSmsElement[] elements = (BSmsElement[])this.getChildren(BSmsElement.class);
        for (int i = 0; i < elements.length; ++i) {
            out.w((Object)"<tr>");
            out.td((Object)elements[i].getName());
            out.td((Object)elements[i].getAdded());
            out.td((Object)new Integer(elements[i].getSendAttempts()));
            BSmsMessage msg = elements[i].getMessage();
            out.td((Object)msg.getPhoneNumbers());
            out.td((Object)msg.getMessage());
            out.w((Object)"</tr>");
        }
        out.endTable();
        super.spy(out);
    }
}

