/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.platCcn.CcnDefSettablePid;

public class CcnVariableDef
implements CcnDefSettablePid {
    private final byte address;
    private final byte bus;
    private byte[] name;
    private final short number;
    private final byte forceLevel;
    private final byte forceDescription;
    private byte pid;

    public CcnVariableDef(byte newAddress, byte newBus, byte[] newName, short newNumber, byte newForceLevel, byte newForceDescription) {
        this.address = newAddress;
        this.bus = newBus;
        int MAX_NAME_SIZE = 8;
        this.name = new byte[8];
        for (int spacePad = 0; spacePad < 8; ++spacePad) {
            this.name[spacePad] = 32;
        }
        if (newName != null) {
            int newNameLength = Math.min(newName.length, 8);
            System.arraycopy(newName, 0, this.name, 0, newNameLength);
        }
        this.number = newNumber;
        this.forceLevel = newForceLevel;
        this.forceDescription = newForceDescription;
    }

    @Override
    public void setPid(byte newPid) {
        this.pid = newPid;
    }

    public byte getAddress() {
        return this.address;
    }

    public byte getBus() {
        return this.bus;
    }

    public byte[] getName() {
        return this.name;
    }

    public short getNumber() {
        return this.number;
    }

    public byte getForceLevel() {
        return this.forceLevel;
    }

    public byte getForceDescription() {
        return this.forceDescription;
    }

    public byte getPid() {
        return this.pid;
    }

    public void setName(byte[] newName) {
        this.name = newName;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        ret.append("addr=").append(this.address & 0xFF).append(",");
        ret.append("bus=").append(this.bus & 0xFF).append(",");
        ret.append("name=").append(this.name != null ? new String(this.name) : null).append(",");
        ret.append("no=").append(this.number & 0xFFFF).append(",");
        ret.append("fcLvl=").append(this.forceLevel & 0xFF).append(",");
        ret.append("fcDesc=").append(this.forceDescription & 0xFF);
        ret.append("]");
        return ret.toString();
    }
}

