/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platCcn.BCcnPlatformService;
import com.tridium.platCcn.CcnCommProps;
import com.tridium.platCcn.CcnObjectDef;
import com.tridium.platCcn.CcnResponseBuffer;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import com.tridium.platCcn.CcnVariableDef;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCcnPlatformServiceQnx
extends BCcnPlatformService {
    public static final Type TYPE = Sys.loadType(BCcnPlatformServiceQnx.class);
    private boolean nativesLoaded = false;
    private volatile boolean timeToDie = false;
    private volatile CountDownLatch startLatch = null;
    private Thread rcvThread;
    private CcnUnsolicitedRcvDriver rcvDrvr;
    protected BComponent portComp = null;
    private Process ccnd;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading platccn native library");
                System.loadLibrary("platccn");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load platccn native library", e);
            }
            return this.nativesLoaded;
        });
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    public void serviceStarted() throws Exception {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load CCN native libraries");
        }
        try {
            AccessController.doPrivileged(() -> {
                File f = new File("/dev/ccn1");
                if (f.exists()) {
                    log.info("CCN daemon already running");
                } else {
                    try {
                        Sys.getLicenseManager().checkFeature("tridium", this.getLicenseFeature());
                        this.ccnd = Runtime.getRuntime().exec("/proc/boot/ccnd -i 1");
                        int patience = 5;
                        while (!f.exists() && patience-- > 0) {
                            Thread.sleep(1000L);
                        }
                        if (patience <= 0) {
                            throw new FileNotFoundException("CCN daemon failed to create local CCN device");
                        }
                        return null;
                    }
                    catch (FeatureNotLicensedException | LicenseDatabaseException throwable) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        if (this.ccnd != null) {
            this.ccnd.destroy();
            this.ccnd = null;
        }
        super.serviceStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openDriverComm(CcnCommProps commProps) {
        if (commProps == null || commProps.getCommPortName() == null) {
            throw new NullPointerException("Error opening comm port, provided null CcnCommProps");
        }
        if (!this.isServiceStarted) {
            throw new RuntimeException("Error opening comm port '" + commProps.getCommPortName() + "', platform service not started");
        }
        BISerialService serialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        serialService.checkPropertiesLoaded();
        this.portComp = (BComponent)((BComponent)serialService).get(commProps.getCommPortName());
        if (this.portComp == null) {
            throw new RuntimeException("Error opening comm port '" + commProps.getCommPortName() + "', port not found");
        }
        Property osPortNameProp = this.portComp.getProperty("osPortName");
        String osName = this.portComp.getString(osPortNameProp);
        commProps.setCommPortName(osName);
        try {
            this.lockSerial(osName);
        }
        catch (PortDeniedException pde) {
            log.severe("Could not open CCN on serial port " + osName + ", failed to obtain lock");
            throw new RuntimeException("Cannot open Ccn");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx openDriverComm0(" + commProps.getCommPortName() + ", " + commProps.getBaudRate() + ", " + commProps.getReceiveAddress() + ", " + commProps.getReceiveBus() + ", " + commProps.getResponseTimeout() + ", " + commProps.getBcastAck() + ", " + commProps.getAlarmAck() + ")");
        }
        boolean success = false;
        try {
            int handle = this.openDriverComm0(commProps);
            if (handle == 0) {
                this.commOpened = true;
                this.timeToDie = false;
            }
            this.handleToName.put(handle, osName);
            if (!this.commOpened) {
                throw new RuntimeException("Error opening comm port '" + commProps.getCommPortName() + "', return code = " + handle);
            }
            this.startLatch = new CountDownLatch(1);
            this.rcvDrvr = new CcnUnsolicitedRcvDriver();
            this.rcvThread = new Thread((Runnable)this.rcvDrvr, "Ccn:UnsolicitedRcvDriver");
            this.rcvThread.start();
            try {
                if (!this.startLatch.await(5L, TimeUnit.SECONDS)) {
                    log.warning("CcnUnsolicitedRcvDriver failed to start in a timely fashion, asynchronous receive may not function properly");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            success = true;
            int n = handle;
            return n;
        }
        finally {
            if (!success) {
                try {
                    log.fine("Failed to open CCN, unlocking serial device " + osName);
                    this.unlockSerial(osName);
                }
                catch (PortDeniedException pde) {
                    log.log(Level.WARNING, "Failed to unlock CCN serial device " + osName, pde);
                }
            }
        }
    }

    @Override
    public CcnResponseBuffer changeTableName(CcnTableDef tableDef) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx changeTableName0(" + tableDef + ")");
        }
        return this.changeTableName0(tableDef);
    }

    @Override
    public CcnResponseBuffer readTable(CcnTableDef tableDef) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx readTable0(" + tableDef + ")");
        }
        return this.readTable0(tableDef);
    }

    @Override
    public CcnResponseBuffer writeTable(CcnTableDef tableDef, byte[] byteArray) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx writeTable0(" + tableDef + ", {" + TextUtil.truncate((String)ByteArrayUtil.toHexString((byte[])byteArray), (int)128) + "})");
        }
        return this.writeTable0(tableDef, byteArray);
    }

    @Override
    public CcnResponseBuffer readVariable(CcnVariableDef varDef) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx readVariable0(" + varDef + ")");
        }
        return this.readVariable0(varDef);
    }

    @Override
    public CcnResponseBuffer writeVariable(CcnVariableDef varDef, float value) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        int bits = Float.floatToIntBits(value);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx writeVariable0(" + varDef + ", " + bits + ")");
        }
        return this.writeVariable0(varDef, bits);
    }

    @Override
    public CcnResponseBuffer autoVariable(CcnVariableDef varDef) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx autoVariable0(" + varDef + ")");
        }
        return this.autoVariable0(varDef);
    }

    @Override
    public CcnResponseBuffer readObjectData(CcnObjectDef objectDef) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx readObjectData0(" + objectDef + ")");
        }
        return this.readObjectData0(objectDef);
    }

    @Override
    public CcnResponseBuffer sendByteArray(byte[] byteArray) {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx sendByteArray0({" + TextUtil.truncate((String)ByteArrayUtil.toHexString((byte[])byteArray), (int)128) + "})");
        }
        return this.sendByteArray0(byteArray);
    }

    @Override
    public int changeExtendedParams(int baudRate, byte rxAddr, byte rxBus, short rxTimeOut, boolean alarmAck, boolean broadcastAck) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx changeExtendedParams0(" + baudRate + ", " + rxAddr + ", " + rxBus + ", " + rxTimeOut + ", " + alarmAck + ", " + broadcastAck + ")");
        }
        return this.changeExtendedParams0(baudRate, rxAddr, rxBus, rxTimeOut, alarmAck, broadcastAck);
    }

    @Override
    public void setLowLevelDebug(boolean enable, int mask) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx setLowLevelDebug0(" + enable + ", " + mask + ")");
        }
        this.setLowLevelDebug0(enable, mask);
    }

    @Override
    public void closeDriver() {
        if (!this.commOpened) {
            throw new RuntimeException("Cannot proceed because driver has no open comm port");
        }
        this.timeToDie = true;
        this.commOpened = false;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CcnPlatformServiceQnx closeDriver0()");
        }
        this.closeDriver0();
        String osPortName = (String)this.handleToName.remove(0);
        try {
            this.unlockSerial(osPortName);
        }
        catch (PortDeniedException pde) {
            log.log(Level.SEVERE, "Failed to unlock Ccn serial device " + osPortName, pde);
        }
        if (this.rcvThread != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("CcnPlatformServiceQnx stopping receive listener");
            }
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join(5000L);
                this.rcvThread = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized native int openDriverComm0(CcnCommProps var1);

    private synchronized native CcnResponseBuffer changeTableName0(CcnTableDef var1);

    private synchronized native CcnResponseBuffer readTable0(CcnTableDef var1);

    private synchronized native CcnResponseBuffer writeTable0(CcnTableDef var1, byte[] var2);

    private synchronized native CcnResponseBuffer readVariable0(CcnVariableDef var1);

    private synchronized native CcnResponseBuffer writeVariable0(CcnVariableDef var1, int var2);

    private synchronized native CcnResponseBuffer autoVariable0(CcnVariableDef var1);

    private synchronized native CcnResponseBuffer readObjectData0(CcnObjectDef var1);

    private synchronized native CcnResponseBuffer sendByteArray0(byte[] var1);

    private synchronized native int changeExtendedParams0(int var1, byte var2, byte var3, short var4, boolean var5, boolean var6);

    private synchronized native void setLowLevelDebug0(boolean var1, int var2);

    private synchronized native void closeDriver0();

    private native CcnUnsolicitedMsg getNextUnsolicitedMessage0();

    class CcnUnsolicitedRcvDriver
    implements Runnable {
        CcnUnsolicitedRcvDriver() {
        }

        @Override
        public void run() {
            BCcnPlatformServiceQnx.this.startLatch.countDown();
            try {
                while (!BCcnPlatformServiceQnx.this.timeToDie) {
                    CcnUnsolicitedMsg msg;
                    block12: {
                        if (BCcnPlatformService.log.isLoggable(Level.FINEST)) {
                            BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver waiting for next message from native layer...");
                        }
                        msg = null;
                        try {
                            msg = BCcnPlatformServiceQnx.this.getNextUnsolicitedMessage0();
                        }
                        catch (Exception exception) {
                            if (!BCcnPlatformService.log.isLoggable(Level.FINEST)) break block12;
                            BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver encountered Exception during getNextUnsolicitedMessage0: " + exception);
                        }
                    }
                    if (BCcnPlatformService.log.isLoggable(Level.FINEST)) {
                        BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver timeToDieValue is '" + BCcnPlatformServiceQnx.this.timeToDie + "'");
                    }
                    if (BCcnPlatformServiceQnx.this.timeToDie) {
                        break;
                    }
                    if (msg != null) {
                        if (BCcnPlatformService.log.isLoggable(Level.FINEST)) {
                            BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver received non-NULL message from native layer");
                        }
                        BCcnPlatformServiceQnx.this.unsolicitedMessageReceived(msg);
                        continue;
                    }
                    if (!BCcnPlatformService.log.isLoggable(Level.FINEST)) continue;
                    BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver received NULL message from native layer");
                }
            }
            finally {
                if (BCcnPlatformService.log.isLoggable(Level.FINEST)) {
                    BCcnPlatformService.log.finest("CcnUnsolicitedRcvDriver Runnable terminating");
                }
            }
        }
    }
}

