/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui.terminal;

import java.util.ArrayList;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class InfinityVt100TextParser
extends TextParser {
    public synchronized Line[] parse(String[] textLines, String[] formatLines) {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < textLines.length; ++i) {
            ArrayList<Segment> segments = new ArrayList<Segment>();
            this.parseFormatLine(formatLines[i], segments);
            Segment[] segmentArray = new Segment[segments.size()];
            segments.toArray(segmentArray);
            Line line = new Line(textLines[i].toCharArray(), segmentArray);
            lines.add(line);
        }
        return lines.toArray(new Line[lines.size()]);
    }

    private void parseFormatLine(String infinityFormatLine, ArrayList<Segment> segmentArrayList) {
        char previousFormatChar = '*';
        for (int i = 0; i < infinityFormatLine.length(); ++i) {
            char newChar = infinityFormatLine.charAt(i);
            if (newChar == previousFormatChar) continue;
            int type = newChar == 'N' ? 0 : (newChar == 'B' ? 6 : (newChar == 'R' ? 4 : (newChar == '-' || newChar == '|' || newChar == 'l' || newChar == 'k' || newChar == 'm' || newChar == 'j' ? 8 : 7)));
            int length = this.countSameChars(infinityFormatLine, i);
            Segment seg = type == 4 ? new Segment(type, 64, i, length) : new Segment(type, i, length);
            segmentArrayList.add(seg);
            previousFormatChar = newChar;
            i = i + length - 1;
        }
    }

    private int countSameChars(String line, int start) {
        int count = 1;
        if (start == line.length() - 1) {
            return count;
        }
        char startingChar = line.charAt(start);
        for (int i = start + 1; i < line.length() && line.charAt(i) == startingChar; ++i) {
            ++count;
        }
        return count;
    }
}

