/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query.util;

import javax.baja.query.BExpression;
import javax.baja.query.util.Exprs;

public class ExpressionBuilder {
    protected BExpression expr;

    public ExpressionBuilder() {
        this(null);
    }

    public ExpressionBuilder(BExpression expr) {
        this.expr = expr;
    }

    public final BExpression getExpression() {
        return this.expr;
    }

    protected ExpressionBuilder doCombine(String operator, BExpression rhs) {
        if (this.expr == null && rhs != null) {
            this.expr = rhs.newExprCopy();
        } else if (rhs != null) {
            this.expr = Exprs.binary(this.expr.newExprCopy(), operator, rhs);
        }
        return this;
    }

    public ExpressionBuilder and(BExpression expr) {
        return this.doCombine("AND", expr);
    }

    public ExpressionBuilder or(BExpression expr) {
        return this.doCombine("OR", expr);
    }

    public ExpressionBuilder not() {
        this.expr = Exprs.unary("NOT", this.expr);
        return this;
    }

    public ExpressionBuilder plus(BExpression expr) {
        return this.doCombine("+", expr);
    }

    public ExpressionBuilder minus(BExpression expr) {
        return this.doCombine("-", expr);
    }

    public ExpressionBuilder times(BExpression expr) {
        return this.doCombine("*", expr);
    }

    public ExpressionBuilder div(BExpression expr) {
        return this.doCombine("/", expr);
    }

    public ExpressionBuilder negative() {
        this.expr = Exprs.unary("-", this.expr);
        return this;
    }
}

