/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.query;

import com.tridium.query.QueryIdioms;
import javax.baja.query.BExpression;
import javax.baja.query.BGroupByColumn;
import javax.baja.query.BGrouping;
import javax.baja.query.BHaving;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.QueryRuntimeException;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;

public class QueryStringVisitor {
    private QueryIdioms idioms_ = new DefaultIdioms();
    protected StringBuffer queryText;
    protected boolean hasFuncProjection = false;
    protected boolean inPredicate = false;

    public QueryStringVisitor() {
        this.initialize();
    }

    protected void initialize() {
        this.queryText = new StringBuffer();
        this.hasFuncProjection = false;
        this.inPredicate = false;
    }

    public QueryIdioms idioms() {
        return this.idioms_;
    }

    public String getQueryString() {
        return this.queryText.toString();
    }

    public void visit(BExpression expr) {
        if (expr instanceof BFieldExpression) {
            this.visit((BFieldExpression)expr);
        } else if (expr instanceof BSimpleExpression) {
            this.visit((BSimpleExpression)expr);
        } else if (expr instanceof BFunctionExpression) {
            this.visit((BFunctionExpression)expr);
        } else if (expr instanceof BBinaryExpression) {
            this.visit((BBinaryExpression)expr);
        } else if (expr instanceof BUnaryExpression) {
            this.visit((BUnaryExpression)expr);
        } else if (expr instanceof BListExpression) {
            this.visit((BListExpression)expr);
        } else {
            throw new QueryRuntimeException("Unknown expression type: " + expr.getType());
        }
    }

    public void visit(BFieldExpression node) {
        this.queryText.append(node.getField());
    }

    public void visit(BSimpleExpression node) {
        this.queryText.append(node.getSimpleValue().toString());
    }

    public void visit(BListExpression node) {
        this.queryText.append('[');
        BExpression[] exprs = node.getExpressions();
        for (int i = 0; i < exprs.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(exprs[i]);
        }
        this.queryText.append(']');
    }

    public void visit(BProjection node) {
        if (node.isDistinct()) {
            this.queryText.append("DISTINCT ");
        }
        BProjectionColumn[] cols = node.getProjectionColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(cols[i]);
        }
        this.queryText.append(' ');
    }

    public void visit(BProjectionColumn node) {
        this.visit(node.getColumnExpression());
        if (node.hasAlias()) {
            this.queryText.append(' ').append(this.idioms().toAliasString(node.getAlias()));
        }
    }

    public void visit(BPredicate node) {
        this.inPredicate = true;
        try {
            this.visit(node.getPredicateExpr());
            this.queryText.append(' ');
        }
        finally {
            this.inPredicate = false;
        }
    }

    public void visit(BOrdering node) {
        BOrderByColumn[] cols = node.getOrderByColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(cols[i]);
        }
        this.queryText.append(' ');
    }

    public void visit(BOrderByColumn node) {
        this.visit(node.getColumnExpression());
        this.queryText.append(' ');
        if (node.isAscending()) {
            this.queryText.append("ASC");
        } else {
            this.queryText.append("DESC");
        }
    }

    public void visit(BGrouping node) {
        BGroupByColumn[] cols = node.getGroupByColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(cols[i]);
        }
        this.queryText.append(' ');
    }

    public void visit(BHaving node) {
        this.inPredicate = true;
        try {
            this.visit(node.getHavingExpr());
            this.queryText.append(' ');
        }
        finally {
            this.inPredicate = false;
        }
    }

    public void visit(BGroupByColumn node) {
        this.visit(node.getColumnExpression());
    }

    public void visit(BFunctionExpression node) {
        this.queryText.append(node.getFunctionName()).append('(');
        if (node.isDistinct()) {
            this.queryText.append("DISTINCT ");
        }
        BExpression[] params = node.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.queryText.append(", ");
            }
            this.visit(params[i]);
        }
        this.queryText.append(")");
        this.hasFuncProjection = true;
    }

    public void visit(BBinaryExpression node) {
        this.queryText.append('(');
        this.visit(node.lhs());
        this.queryText.append(' ').append(node.op()).append(' ');
        this.visit(node.rhs());
        this.queryText.append(')');
    }

    public void visit(BUnaryExpression node) {
        this.queryText.append('(');
        if (!node.isPostfix()) {
            this.queryText.append(node.op()).append(' ');
            this.visit(node.operand());
        } else {
            this.visit(node.operand());
            this.queryText.append(' ').append(node.op());
        }
        this.queryText.append(')');
    }

    public class DefaultIdioms
    implements QueryIdioms {
        @Override
        public String quote(String toQuote) {
            return "'" + toQuote + "'";
        }

        @Override
        public String toAliasString(String alias) {
            return "AS " + this.quote(alias);
        }
    }
}

