/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.proxy;

import javax.baja.control.BControlPoint;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public final class BLonFloatProxyExt
extends BLonProxyExt {
    public static final Property readValue = BLonFloatProxyExt.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property writeValue = BLonFloatProxyExt.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Type TYPE = Sys.loadType(BLonFloatProxyExt.class);
    private boolean nanIsNull = false;
    private boolean nullSpecified = false;
    private double nullVal;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void extStarted() {
        super.extStarted();
        this.checkFacets();
    }

    public void pointFacetsChanged() {
        super.pointFacetsChanged();
        this.checkFacets();
        BControlPoint cp = (BControlPoint)this.getParent();
        BFacets pntFcts = cp.getFacets();
        BUnit pntUnit = (BUnit)pntFcts.get("units");
        if (pntUnit == null) {
            return;
        }
        BFacets devFcts = this.getDeviceFacets();
        BUnit devUnit = (BUnit)devFcts.get("units");
        if (devUnit == null) {
            return;
        }
        if (!pntUnit.isConvertible(devUnit)) {
            return;
        }
        BNumber curDevMin = (BNumber)devFcts.get("min", (BObject)BFloat.NEGATIVE_INFINITY);
        double devMin = curDevMin != BFloat.NEGATIVE_INFINITY ? devUnit.convertTo(pntUnit, curDevMin.getNumeric()) : Double.NEGATIVE_INFINITY;
        BNumber curDevMax = (BNumber)devFcts.get("max", (BObject)BFloat.POSITIVE_INFINITY);
        double devMax = curDevMax != BFloat.POSITIVE_INFINITY ? (double)((float)devUnit.convertTo(pntUnit, curDevMax.getNumeric())) : Double.POSITIVE_INFINITY;
        double newMin = ((BNumber)pntFcts.get("min", (BObject)BFloat.NEGATIVE_INFINITY)).getDouble();
        double newMax = ((BNumber)pntFcts.get("max", (BObject)BFloat.POSITIVE_INFINITY)).getDouble();
        double min = Math.max(newMin, devMin);
        double max = Math.min(newMax, devMax);
        if (min != newMin || max != newMax) {
            BInteger p = (BInteger)devFcts.get("precision", null);
            int prec = p == null ? 1 : p.getInt();
            BFacets f = BFacets.makeNumeric((BUnit)pntUnit, (int)prec, (double)min, (double)max);
            cp.setFacets(f);
        }
    }

    @Override
    public BStatusValue getStatusValue(BLonPrimitive newValue) {
        double num = newValue.getDataAsDouble();
        BStatusNumeric sNum = new BStatusNumeric(num);
        if (Double.isNaN(num) && this.nanIsNull) {
            sNum.setStatusNull(true);
        } else if (this.nullSpecified && num == this.nullVal) {
            sNum.setStatusNull(true);
        }
        return sNum;
    }

    @Override
    public BLonPrimitive getPrimitiveValue(BStatusValue value) {
        BLonData dataPoint = this.getDataPoint();
        double val = ((BStatusNumeric)value).getValue();
        BLonElementQualifiers e = LonFacetsUtil.getQualifiers(this.targetProp.getFacets());
        return ((BLonPrimitive)dataPoint.get(this.targetProp)).makeFromDouble(val, e);
    }

    private void checkFacets() {
        BControlPoint cp = (BControlPoint)this.getParent();
        BFacets pntFcts = cp.getFacets();
        this.nanIsNull = pntFcts.getb("nanIsNull", false);
        double d = pntFcts.getd("isNull", Double.NaN);
        if (Double.isNaN(d)) {
            this.nullSpecified = false;
        } else {
            this.nullSpecified = true;
            this.nullVal = d;
        }
    }
}

