/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BILonNetworkSimple;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLonSimple
extends BLonPrimitive {
    public static final BLonSimple DEFAULT = new BLonSimple(null);
    public static final Type TYPE = Sys.loadType(BLonSimple.class);
    BSimple value;

    public static BLonSimple make(BSimple d) {
        return new BLonSimple(d);
    }

    private BLonSimple(BSimple s) {
        this.value = s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLonSimple) {
            return this.value.equals((Object)((BLonSimple)((Object)obj)).value);
        }
        return false;
    }

    public String toString(Context context) {
        return this.value.toString(context);
    }

    public String encodeToString() throws IOException {
        return this.encodeClass(this.value) + " " + this.value.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int typNamLen = s.indexOf(32);
        BSimple d = this.decodeClass(s.substring(0, typNamLen));
        return BLonSimple.make((BSimple)d.decodeFromString(s.substring(typNamLen + 1)));
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeClass(this.value));
        this.value.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BSimple d = this.decodeClass(in.readUTF());
        return BLonSimple.make((BSimple)d.decode(in));
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void toOutputStream(LonOutputStream out, BLonElementQualifiers e) {
        BILonNetworkSimple val = (BILonNetworkSimple)this.value;
        val.toOutputStream(out);
    }

    @Override
    public BLonPrimitive fromInputStream(LonInputStream in, BLonElementQualifiers e) {
        BILonNetworkSimple val = (BILonNetworkSimple)this.value;
        BSimple newValue = (BSimple)val.fromInputStream(in);
        if (newValue.equals((Object)val)) {
            return this;
        }
        return BLonSimple.make(newValue);
    }

    @Override
    public String getDataAsString() {
        String s;
        try {
            s = this.value.encodeToString();
        }
        catch (Throwable e) {
            s = "";
        }
        return s;
    }

    @Override
    public BLonPrimitive makeFromString(String stringValue) {
        try {
            return BLonSimple.make((BSimple)this.value.decodeFromString(stringValue));
        }
        catch (Throwable e) {
            return null;
        }
    }
}

