/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAliasTable
extends BComponent {
    public static final Property aliasCount = BAliasTable.newProperty((int)1, (int)0, null);
    public static final Property aliasOffset = BAliasTable.newProperty((int)4, (int)0, null);
    public static final Type TYPE = Sys.loadType(BAliasTable.class);

    public int getAliasCount() {
        return this.getInt(aliasCount);
    }

    public void setAliasCount(int v) {
        this.setInt(aliasCount, v, null);
    }

    public int getAliasOffset() {
        return this.getInt(aliasOffset);
    }

    public void setAliasOffset(int v) {
        this.setInt(aliasOffset, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAliasTable() {
    }

    public BAliasTable(int count) {
        this.setAliasCount(count);
        this.verifyAliasCount();
    }

    public void started() throws Exception {
        super.started();
        if (this.getAliasCount() > 0) {
            this.verifyAliasCount();
        }
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == aliasCount) {
            this.verifyAliasCount();
        }
    }

    public void verifyAliasCount() {
        Property prop;
        String entryName;
        int i;
        int count = this.getAliasCount();
        for (i = 0; i < count; ++i) {
            entryName = this.propName(i);
            prop = this.getProperty(entryName);
            if (prop != null) continue;
            this.add(entryName, (BValue)new BAliasConfigData(), null);
        }
        entryName = this.propName(i++);
        while ((prop = this.getProperty(entryName)) != null) {
            this.remove(prop);
            entryName = this.propName(i++);
        }
    }

    public void clearTable() {
        SlotCursor c = this.getProperties();
        while (c.next(BAliasConfigData.class)) {
            ((BAliasConfigData)c.get()).clearData();
        }
    }

    public BAliasConfigData getAliasEntry(int index) {
        return (BAliasConfigData)this.get(this.propName(index));
    }

    public void setAliasEntry(int index, BAliasConfigData ad) {
        this.set(this.propName(index), (BValue)ad);
    }

    public BAliasConfigData[] getAliasArray() {
        BAliasConfigData[] a = new BAliasConfigData[this.getAliasCount()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.getAliasEntry(i);
        }
        return a;
    }

    private String propName(int ndx) {
        return "entry" + ndx;
    }
}

