/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.NvDev;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BLonObjectFolder
extends BFolder
implements BILonLoadable {
    public static final Action upload = BLonObjectFolder.newAction((int)0, (BValue)new BUploadParameters(), null);
    public static final Action download = BLonObjectFolder.newAction((int)0, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE = Sys.loadType(BLonObjectFolder.class);
    private boolean objUploadInProgress = false;
    private boolean objDownloadInProgress = false;
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/objectFolder.png");

    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BLonDevice.TYPE) || parent.getType().is(TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        return !child.getType().is(BDeviceFolder.TYPE);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        return NvDev.fixWireSheet(list, cx);
    }

    public final BLonNetwork getLonNetwork() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!p.getType().is(BLonNetwork.TYPE)) continue;
            return (BLonNetwork)p;
        }
        throw new IllegalStateException();
    }

    @Override
    public final BLonDevice getLonDevice() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!p.getType().is(BLonDevice.TYPE)) continue;
            return (BLonDevice)p;
        }
        throw new IllegalStateException();
    }

    public final void doUpload(BUploadParameters p, Context cx) throws Exception {
        this.getLonDevice().checkState();
        new BUploadJob(this, p, cx).submit(cx);
    }

    public final void doDownload(BDownloadParameters p, Context cx) throws Exception {
        this.getLonDevice().checkState();
        new BDownloadJob(this, p, cx).submit(cx);
    }

    public void checkUpload() {
    }

    @Override
    public void beginUpload() {
        BLonDevice dev = this.getLonDevice();
        if (!dev.isUpLoadInProgress()) {
            dev.initUpload(true);
            this.objUploadInProgress = true;
        }
    }

    @Override
    public void endUpload() {
        BLonDevice dev = this.getLonDevice();
        if (this.objUploadInProgress) {
            dev.cleanupUpload();
            this.objUploadInProgress = false;
        }
    }

    public void checkDownload() {
    }

    @Override
    public void beginDownload() {
        BLonDevice dev = this.getLonDevice();
        if (!dev.isDownLoadInProgress()) {
            dev.initDownload(true);
            this.objDownloadInProgress = true;
        }
    }

    @Override
    public void endDownload() {
        BLonDevice dev = this.getLonDevice();
        if (!dev.isDownLoadInProgress()) {
            dev.cleanupDownload();
            this.objDownloadInProgress = false;
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

