/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateRecord;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import com.tridium.lonworks.util.xif.XifLineReader;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XLonDataUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.lonworks.enums.BLonConfigScope;

public class ConfigFileParser {
    private NodeSelfDoc nodeSelfDoc = null;
    private XifLineReader reader;
    private PrintStream out;
    private CrossReference crossRef;

    public ConfigFileParser(XifLineReader reader, PrintStream out, CrossReference crossRef, String selfDoc) {
        this.reader = reader;
        this.out = out;
        this.crossRef = crossRef;
        this.nodeSelfDoc = new NodeSelfDoc(selfDoc);
    }

    public Vector<XConfigProperty> parse() {
        Vector<XConfigProperty> vect = new Vector<XConfigProperty>();
        try {
            String line;
            int ndx = 0;
            while ((line = this.readRecord()).length() != 0) {
                String comment = line.substring(line.indexOf(";") + 1);
                if ((line = line.substring(0, line.indexOf(";"))).equals("")) break;
                vect.addElement(this.parseConfig(line, comment, ndx++));
            }
            DuplicateNamesUtil.eliminateDuplicateNames(vect);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vect;
    }

    private String readRecord() throws IOException {
        boolean done = false;
        StringBuffer sb = new StringBuffer();
        while (!done) {
            String line = this.reader.readXifLine(false);
            if (line.length() == 0) {
                return "";
            }
            if (line.startsWith("\"")) {
                line = line.substring(1);
            }
            if (line.indexOf(";") >= 0) {
                done = true;
            }
            sb.append(line);
        }
        return sb.toString();
    }

    private XConfigProperty parseConfig(String line, String comment, int index) {
        String name;
        ConfigTemplateRecord tmplRec = new ConfigTemplateRecord(line);
        XConfigProperty cp = new XConfigProperty();
        cp.scope = XLonDataUtil.scopeToString(tmplRec.getHdr());
        cp.select = tmplRec.getSelect();
        cp.modifyFlag = XLonDataUtil.flagToString(tmplRec.getFlags());
        cp.length = tmplRec.getLength();
        cp.dimension = tmplRec.getDimension();
        if (tmplRec.hasMin()) {
            cp.min = tmplRec.getMin();
        }
        if (tmplRec.hasMax()) {
            cp.max = tmplRec.getMax();
        }
        if (this.crossRef != null) {
            try {
                CpType typ = this.crossRef.findCpType(tmplRec.getTypeScope(), tmplRec.getConfigIndex());
                if (typ.inherited && cp.scope.equals(BLonConfigScope.object.getTag())) {
                    int objType = this.nodeSelfDoc.getObjectType(SelfDocUtil.getFirstIndex(cp.select));
                    cp.principalNv = this.crossRef.getPrincipalNv(objType);
                }
                if (tmplRec.getTypeScope() == 0) {
                    cp.scptType = "Cp" + NameUtil.toJavaName(typ.node.name, true);
                } else {
                    cp.setTypeDef("Cp" + NameUtil.toJavaName(typ.node.name, true));
                    this.crossRef.mark(typ.scope);
                }
            }
            catch (Throwable e) {
                this.warning(e);
            }
        }
        if ((name = this.getCpName(cp, tmplRec, comment)).length() == 0) {
            name = "config" + index;
        } else if (name.startsWith("nci")) {
            name = name.substring(3);
        } else if (name.startsWith("Cp")) {
            name = name.substring(2);
        }
        name = NameUtil.toJavaName(name, false);
        cp.setName(name);
        return cp;
    }

    private String getCpName(XConfigProperty cp, ConfigTemplateRecord tmplRec, String comment) {
        int pos = comment.indexOf("n=\"");
        if (pos >= 0) {
            return comment.substring(pos + 3, comment.indexOf("\"", pos + 4));
        }
        try {
            int objType;
            if (this.crossRef != null && cp.scope.equals("object") && (objType = this.getObjectType(cp.select)) >= 0) {
                try {
                    return this.crossRef.getCpName(objType, tmplRec.getTypeScope(), tmplRec.getConfigIndex());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return cp.scptType.length() > 0 ? cp.scptType : cp.getTypeDef();
        }
        catch (Throwable e) {
            this.warning(e);
            return "";
        }
    }

    private int getObjectType(String select) {
        try {
            StringTokenizer tok = new StringTokenizer(select, ",-~.");
            int objNdx = Integer.decode(tok.nextToken());
            return this.nodeSelfDoc.getObject(objNdx).getType();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void warning(Throwable e) {
        String msg = e.getMessage();
        String exception = e instanceof RuntimeException ? "" : e.getClass().getName();
        this.out.println("WARNING:" + exception + " " + (msg != null ? msg : ""));
    }

    static class DuplicateNamesUtil {
        DuplicateNamesUtil() {
        }

        private static void bucketize(Hashtable<String, Vector<XConfigProperty>> sameNameBuckets, Iterator<XConfigProperty> xit) {
            while (xit.hasNext()) {
                XConfigProperty xConfig = xit.next();
                String xConfigName = xConfig.getName();
                Vector<XConfigProperty> sameNameBucket = sameNameBuckets.get(xConfigName);
                if (sameNameBucket == null) {
                    sameNameBucket = new Vector();
                    sameNameBuckets.put(xConfigName, sameNameBucket);
                }
                sameNameBucket.addElement(xConfig);
            }
        }

        private static Hashtable<String, Vector<XConfigProperty>> bucketize(Vector<XConfigProperty> xConfigs) {
            Hashtable<String, Vector<XConfigProperty>> sameNameBuckets = new Hashtable<String, Vector<XConfigProperty>>(xConfigs.size());
            DuplicateNamesUtil.bucketize(sameNameBuckets, xConfigs.iterator());
            return sameNameBuckets;
        }

        private static void examineBucket(Vector<XConfigProperty> sameNameBucket) {
            if (sameNameBucket.size() > 1) {
                DuplicateNamesUtil.addNameSuffixes(sameNameBucket.elements());
            }
        }

        private static void addNameSuffixes(Enumeration<XConfigProperty> sameNameCps) {
            int suffix = 1;
            while (sameNameCps.hasMoreElements()) {
                XConfigProperty cp = sameNameCps.nextElement();
                cp.setName(cp.getName() + suffix);
                ++suffix;
            }
        }

        static void eliminateDuplicateNames(Vector<XConfigProperty> xConfigs) {
            Enumeration<Vector<XConfigProperty>> eSameNameBuckets = DuplicateNamesUtil.bucketize(xConfigs).elements();
            while (eSameNameBuckets.hasMoreElements()) {
                DuplicateNamesUtil.examineBucket(eSameNameBuckets.nextElement());
            }
        }
    }
}

