/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.device.DeviceFacets;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;
import javax.baja.util.ICoalesceable;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

public class TimedCoalesceQueue
implements Worker.ITodo {
    Entry[] table;
    int hashSize;
    int threshold;
    float loadFactor = 0.75f;
    Entry head;
    Entry tail;
    int size;
    int maxSize;
    long fullCount;
    int rehashCnt = 0;

    public TimedCoalesceQueue(int maxSize) {
        this.maxSize = maxSize;
        this.table = new Entry[maxSize / 3];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public TimedCoalesceQueue() {
        this(Integer.MAX_VALUE);
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.maxSize;
    }

    public synchronized Object peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    public synchronized Object dequeue() throws InterruptedException {
        if (this.head == null) {
            return null;
        }
        long nxtTime = ((ITimed)this.head.value).getTime();
        long ticks = Clock.ticks();
        while (nxtTime > ticks) {
            this.wait(nxtTime - ticks);
            nxtTime = ((ITimed)this.head.value).getTime();
            ticks = Clock.ticks();
        }
        Entry entry = this.head;
        this.head = entry.next;
        if (this.head == null) {
            this.tail = null;
        }
        entry.next = null;
        --this.size;
        if (entry.value instanceof ICoalesceable) {
            this.remove((ICoalesceable)entry.value);
        }
        return entry.value;
    }

    public synchronized Object dequeue(int timeout) throws InterruptedException {
        while (this.size == 0) {
            if (timeout == -1) {
                this.wait();
                continue;
            }
            this.wait(timeout);
            break;
        }
        return this.dequeue();
    }

    public synchronized boolean enqueue(ITimed value) throws QueueFullException {
        ICoalesceable newc;
        Entry dup;
        if (value instanceof ICoalesceable && (dup = this.get(newc = (ICoalesceable)value)) != null) {
            return false;
        }
        if (this.size >= this.maxSize) {
            ++this.fullCount;
            throw new QueueFullException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        boolean restart = false;
        Entry entry = this.newEntry(value);
        entry.next = null;
        if (this.tail == null) {
            this.head = this.tail = entry;
            restart = true;
        } else {
            long vTime = value.getTime();
            if (((ITimed)this.tail.value).getTime() <= vTime) {
                this.tail.next = entry;
                this.tail = entry;
            } else if (((ITimed)this.head.value).getTime() > vTime) {
                entry.next = this.head;
                this.head = entry;
                restart = true;
            } else {
                Entry e = this.head;
                while (e.next != null) {
                    if (((ITimed)e.value).getTime() <= vTime && ((ITimed)e.next.value).getTime() > vTime) {
                        entry.next = e.next;
                        e.next = entry;
                        break;
                    }
                    e = e.next;
                }
            }
        }
        ++this.size;
        if (restart) {
            this.notifyAll();
        }
        return true;
    }

    Entry newEntry(ITimed v) {
        if (v instanceof ICoalesceable) {
            return this.put((ICoalesceable)v);
        }
        return new Entry(v);
    }

    public synchronized Object[] toArray() {
        Object[] a = new Object[this.size];
        Entry p = this.head;
        int i = 0;
        while (p != null) {
            a[i] = p.value;
            p = p.next;
            ++i;
        }
        return a;
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public Runnable todo(int timeout) throws InterruptedException {
        return (Runnable)this.dequeue(timeout);
    }

    Entry get(ICoalesceable c) {
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        Entry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && ((ICoalesceable)e.value).getCoalesceKey().equals(key)) {
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.hashNext;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.hashNext = newTable[index];
                newTable[index] = e;
            }
        }
        ++this.rehashCnt;
    }

    Entry put(ICoalesceable c) {
        if (this.hashSize >= this.threshold) {
            this.rehash();
            return this.put(c);
        }
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        Entry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = new Entry(c);
        e.hash = hash;
        e.hashNext = tab[index];
        tab[index] = e;
        ++this.hashSize;
        return e;
    }

    Object remove(ICoalesceable c) {
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        Entry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && ((ICoalesceable)e.value).getCoalesceKey().equals(key)) {
                if (prev != null) {
                    prev.hashNext = e.hashNext;
                } else {
                    tab[index] = e.hashNext;
                }
                --this.hashSize;
                return e.value;
            }
            prev = e;
            e = e.hashNext;
        }
        throw new IllegalStateException();
    }

    public synchronized void spy(SpyWriter out) throws Exception {
        out.trTitle((Object)"TimedCoalesceQueue", 1);
        out.startProps("Queue");
        out.prop((Object)"size", this.size);
        out.prop((Object)"maxSize", this.maxSize);
        out.prop((Object)"fullCount", (Object)Long.toString(this.fullCount));
        Entry e = this.head;
        while (e != null) {
            DeviceFacets.TimedInvocation ti = (DeviceFacets.TimedInvocation)e.value;
            out.prop((Object)ti.getName(), (Object)Long.toString(ti.getTime()));
            e = e.next;
        }
        out.endProps();
        out.startProps("CoalesceQueue");
        out.prop((Object)"hashSize", this.hashSize);
        out.prop((Object)"threshold", this.threshold);
        out.prop((Object)"rehashCnt", this.rehashCnt);
        for (int i = 0; i < this.table.length; ++i) {
            e = this.table[i];
            while (e != null) {
                DeviceFacets.TimedInvocation ti = (DeviceFacets.TimedInvocation)e.value;
                out.prop((Object)Integer.toString(i, 16), (Object)ti.getName());
                e = e.hashNext;
            }
        }
        out.endProps();
    }

    static class Entry {
        Entry next;
        Object value;
        int hash;
        Entry hashNext;

        Entry(Object v) {
            this.value = v;
        }
    }

    public static interface ITimed {
        public long getTime();
    }
}

