/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;

public class LonFileUtil {
    public static BIFile getFile(String filename) {
        try {
            return (BIFile)BOrd.make((String)LonFileUtil.fixFilename(filename)).resolve().get();
        }
        catch (Throwable e) {
            throw new BajaRuntimeException("Unable to access file " + filename, e);
        }
    }

    public static BIFile getFile(BDirectory dir, String filename) {
        try {
            return dir.getFileSpace().findFile(LonFileUtil.getFilePath(dir, filename));
        }
        catch (Throwable e) {
            throw new BajaRuntimeException("Unable to access file " + filename + " in " + dir.getFilePath().getBody(), e);
        }
    }

    private static FilePath getFilePath(BDirectory dir, String filename) {
        return new FilePath(dir.getFilePath().getBody() + "/" + filename);
    }

    public static BDirectory getDirectory(String filename) {
        try {
            BAbstractFile f = (BAbstractFile)BOrd.make((String)LonFileUtil.fixFilename(filename)).resolve().get();
            if (!f.isDirectory()) {
                throw new RuntimeException(filename + " is not a directory.");
            }
            return (BDirectory)f;
        }
        catch (Throwable e) {
            throw new BajaRuntimeException("Unable to access directory " + filename, e);
        }
    }

    public static BIFile getOrMakeFile(BDirectory dir, String filename) {
        try {
            FilePath fp = LonFileUtil.getFilePath(dir, filename);
            BIFile f = dir.getFileSpace().makeFile(fp);
            return f;
        }
        catch (Throwable e) {
            throw new BajaRuntimeException("Unable to create directory " + filename, e);
        }
    }

    private static String fixFilename(String filename) {
        String fname = filename.replace('\\', '/');
        return "file:/" + fname;
    }
}

