/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.baja.sys.BObject;

public class PTable {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    private static final int PAD = 3;
    private int numColumns;
    private Vector<Row> table = new Vector();
    private Row row;
    private int[] colAttr;

    public PTable(String[] headers) {
        this(headers, 0);
    }

    public PTable(String[] headers, int defAttr) {
        this.table.addElement(new Row(headers));
        this.numColumns = headers.length;
        this.row = new Row(this.numColumns);
        this.colAttr = new int[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.colAttr[i] = defAttr;
        }
    }

    public void setColumnAttribute(int col, int attr) {
        if (col < this.numColumns) {
            this.colAttr[col] = attr;
        }
    }

    public void add(int entry) {
        this.add(Integer.toString(entry));
    }

    public void add(BObject entry) {
        this.add(entry.toString());
    }

    public void add(String entry) {
        if (this.row == null) {
            this.row = new Row(this.numColumns);
        }
        this.row.add(entry);
        if (this.row.index >= this.numColumns) {
            this.endRow();
        }
    }

    public void add(String entry, int mult) {
        while (mult-- > 0) {
            this.add(entry);
        }
    }

    public void addBanner(String ban) {
        if (this.row == null) {
            this.row = new Row(this.numColumns);
        }
        this.row.banner = ban;
        this.endRow();
    }

    public void newRow() {
        if (this.row != null) {
            this.table.addElement(this.row);
        }
        this.row = new Row(this.numColumns);
    }

    public void endRow() {
        this.table.addElement(this.row);
        this.row = null;
    }

    public void toString(PrintWriter out) {
        int j;
        Object r;
        int i;
        int n;
        int numRows = this.table.size();
        Object[] tab = new Row[numRows];
        int[] colWidth = new int[this.numColumns];
        int tableWidth = 0;
        this.table.copyInto(tab);
        for (n = 0; n < this.numColumns; ++n) {
            colWidth[n] = 0;
        }
        for (i = 0; i < numRows; ++i) {
            r = tab[i];
            for (j = 0; j < ((Row)r).index; ++j) {
                int len = ((Row)r).entries[j].length();
                if (len <= colWidth[j]) continue;
                colWidth[j] = len;
            }
        }
        try {
            for (n = 0; n < this.numColumns; ++n) {
                tableWidth += colWidth[n] + 3;
            }
            this.fill(out, tableWidth, '=');
            out.println();
            for (i = 0; i < numRows; ++i) {
                r = tab[i];
                for (j = 0; j < ((Row)r).index; ++j) {
                    String e = ((Row)r).entries[j];
                    int pad = colWidth[j] - e.length() + 3;
                    int leftPad = i == 0 ? pad - pad / 2 : (this.colAttr[j] == 2 ? 1 : (this.colAttr[j] == 1 ? pad - 1 : pad - pad / 2));
                    this.fill(out, leftPad, ' ');
                    out.print(e);
                    this.fill(out, pad - leftPad, ' ');
                }
                if (((Row)r).banner != null) {
                    out.print(((Row)r).banner);
                }
                out.println();
                if (i != 0) continue;
                this.fill(out, tableWidth, '-');
                out.println();
            }
            this.fill(out, tableWidth, '=');
            out.println();
        }
        catch (Throwable e) {
            throw new RuntimeException("error building ptable string " + e);
        }
    }

    private void fill(PrintWriter out, int len, char c) throws IOException {
        String s = new Character(c).toString();
        while (len-- > 0) {
            out.print(s);
        }
    }

    private static class Row {
        String[] entries;
        int index;
        String banner = null;

        Row(int n) {
            this.entries = new String[n];
            this.index = 0;
        }

        Row(String[] r) {
            this.entries = r;
            this.index = r.length;
        }

        void add(String e) {
            this.entries[this.index++] = e;
        }
    }
}

