/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.LonPointAlias;
import com.tridium.lonworks.netmgmt.LonPointPseudo;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLonBindJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE = Sys.loadType(BLonBindJob.class);
    private int completes = 0;
    private ConnectionTable connTable;
    private Connection[] table;
    private TagConnection[] tags;
    private NAddressManager adrMan;
    private GroupTable groupTable;
    private boolean debug;
    private BTagLinkEntry tagEntry = null;
    private BLonDevice selectDev = null;
    boolean bindMtags = true;
    Vector<BLonDevice> offDevs = new Vector();

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLonBindJob() {
    }

    public BLonBindJob(BLonNetmgmt netMgmt, BString selects, BTagLinkEntry tagEntry, boolean debug) {
        super(netMgmt);
        this.connTable = new ConnectionTable(netMgmt.lonNetwork());
        this.tags = this.connTable.getMessageTagTable();
        this.groupTable = this.connTable.getGroupTable();
        this.tagEntry = tagEntry;
        this.debug = debug;
        this.adrMan = (NAddressManager)((BLonNetwork)netMgmt.getParent()).addressManager();
        this.groupTable.bindJob = this;
        if (tagEntry != null) {
            this.table = new Connection[0];
            return;
        }
        this.table = this.connTable.getConnectionArray();
        if (selects == null) {
            return;
        }
        String s = selects.getString();
        if (s.length() > 0) {
            this.bindMtags = false;
            StringTokenizer st = new StringTokenizer(s, ",");
            Vector<Connection> v = new Vector<Connection>();
            while (st.hasMoreTokens()) {
                int sel = Integer.decode(st.nextToken());
                v.addElement(this.table[sel]);
            }
            this.table = new Connection[v.size()];
            v.copyInto(this.table);
        }
    }

    public BLonBindJob(BLonNetmgmt netMgmt, BLonDevice dev, boolean debug) {
        this(netMgmt, dev, true, debug);
    }

    public BLonBindJob(BLonNetmgmt netMgmt, BLonDevice dev, boolean bindMtags, boolean debug) {
        super(netMgmt);
        this.connTable = new ConnectionTable(netMgmt.lonNetwork());
        this.tags = this.connTable.getMessageTagTable();
        this.groupTable = this.connTable.getGroupTable();
        this.selectDev = dev;
        this.debug = debug;
        this.adrMan = (NAddressManager)((BLonNetwork)netMgmt.getParent()).addressManager();
        this.groupTable.bindJob = this;
        this.table = this.connTable.getConnectionArray();
        Vector<Connection> v = new Vector<Connection>();
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null || !this.table[i].containsDevice(dev)) continue;
            v.addElement(this.table[i]);
        }
        this.table = new Connection[v.size()];
        v.copyInto(this.table);
    }

    static void bindDevice(BLonNetmgmt netMgmt, BLonDevice dev) {
        BLonBindJob req = new BLonBindJob(netMgmt, dev, false);
        req.run();
    }

    @Override
    public void run() {
        this.log().start("Binding");
        if (this.debug) {
            System.out.println("Binding");
        }
        try {
            if (this.bindMtags) {
                this.processMessageTags();
            }
            this.myProgress(5);
            this.selectGroup();
            this.myProgress(10);
            this.status("Binding - processing groups");
            this.groupTable.processGroups(this.offDevs);
            this.myProgress(30);
            this.status("Binding - processing links");
            this.processConnections();
            this.myProgress(80);
            this.removeObsolete();
            this.verifyChannelPriorities();
            this.updateTagStatus();
            if (this.adrMan.isRouted() && Lon.n()) {
                this.groupTable.updateGroupRouteFlags(this.adrMan.routerManager());
            }
            this.setDevicesOnline();
            this.end();
        }
        catch (JobCancelException e) {
            this.setDevicesOnline();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.fatal("Bind command failed.  ", e);
        }
        this.netMgmt.updateLinkTable(this.connTable);
        if (this.debug) {
            System.out.println("Bind complete");
        }
    }

    private void setDevicesOnline() {
        for (int i = 0; i < this.offDevs.size(); ++i) {
            BLonDevice dev = this.offDevs.elementAt(i);
            try {
                if (!dev.isConfigOnline()) {
                    if (Lon.n()) {
                        NmUtil.setDeviceState(dev, BLonNodeState.configOnline);
                    }
                    dev.getDeviceData().set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
                }
                try {
                    dev.bindComplete();
                }
                catch (Throwable throwable) {}
                continue;
            }
            catch (Throwable e) {
                System.out.println("ERROR: in GroupTable.setDevicesOnline() - comm failure to " + dev.getDisplayName(null));
            }
        }
    }

    private void updateTagStatus() {
        for (int i = 0; i < this.tags.length; ++i) {
            Group grp;
            int groupNum;
            TagConnection tagCnctn = this.tags[i];
            if (tagCnctn.isError() || (groupNum = tagCnctn.getAddressGroup()) == -1 || (grp = this.groupTable.getGroup(groupNum)) == null || !grp.isUpdated()) continue;
            tagCnctn.setUpdatedStatus();
        }
    }

    private void processMessageTags() {
        for (int i = 0; i < this.tags.length; ++i) {
            TagConnection tagCnctn = this.tags[i];
            TagPoint out = tagCnctn.getOutput();
            if (this.tagEntry != null) {
                if (!out.getDeviceName().equals(SlotPath.unescape((String)this.tagEntry.getOutputDevice())) || !out.getTagName().equals(SlotPath.unescape((String)this.tagEntry.getOutputTag()))) continue;
                this.processTagConnection(tagCnctn);
                return;
            }
            if (this.selectDev != null) {
                if (!tagCnctn.containsDevice(this.selectDev)) continue;
                this.processTagConnection(tagCnctn);
                continue;
            }
            this.processTagConnection(tagCnctn);
        }
    }

    private void processTagConnection(TagConnection tagCnctn) {
        boolean drtyDsc;
        TagPoint out;
        if (this.debug) {
            System.out.println("processTagConnection: " + tagCnctn);
        }
        if ((out = tagCnctn.getOutput()) == null) {
            return;
        }
        int grpNum = tagCnctn.getAddressGroup();
        Group grp = grpNum >= 0 ? this.groupTable.getGroup(grpNum) : null;
        BLonDevice outDev = out.getLonDevice();
        if (out.isObsolete()) {
            if (grp != null) {
                grp.removeMember(this.connTable.getDeviceIndex(outDev));
            }
            this.groupTable.clearAddressEntry(outDev, out.getTagIndex(), this.offDevs);
            tagCnctn.setStatus(BLonLinkStatus.unbound);
            tagCnctn.setAddressGroup(-1);
            return;
        }
        boolean bl = drtyDsc = out.getStatus() == BLonLinkStatus.dirtyDescriptor;
        if (drtyDsc && grp != null) {
            grp.setLinkType(BLonLinkType.reliable);
            grp.setStatus(1);
            tagCnctn.setStatus(BLonLinkStatus.bound);
            return;
        }
        if (!(drtyDsc || !tagCnctn.isError() && tagCnctn.isNew())) {
            return;
        }
        TagPoint[] ins = tagCnctn.getInputs();
        if (ins.length > 1 && grpNum >= 0) {
            if (this.connTable.groupUse(grpNum, true) <= 1 && this.groupTable.reconfigTagGroup(tagCnctn, grpNum, this.offDevs)) {
                return;
            }
            if (!this.groupTable.moveTagPoint(out, grpNum, this.offDevs)) {
                tagCnctn.setStatus(BLonLinkStatus.groupError);
                return;
            }
            grp = null;
            grpNum = -1;
            tagCnctn.setAddressGroup(-1);
        }
        if (ins.length == 1 && grp != null && !ins[0].isMtag()) {
            grp.removeMember(this.connTable.getDeviceIndex(outDev));
            tagCnctn.setAddressGroup(-1);
        }
        if (ins.length == 1 && !ins[0].isMtag()) {
            BDeviceData dd = ins[0].getLonDevice().getDeviceData();
            BAddressEntry addrEntry = BAddressEntry.makeSubnetNodeEntry(dd.getSubnetNodeId(), 2, dd.getWorkingDomain(), this.netMgmt.getLinkDescriptors().getDescriptor(2));
            if (this.debug) {
                System.out.println("\n  update message tagCnctn " + out.getTagIndex() + " in " + outDev.getDisplayName(null));
            }
            outDev.getDeviceData().setAddressEntry(out.getTagIndex(), addrEntry);
            try {
                this.updateAddressTable(outDev, out.getTagIndex());
            }
            catch (Throwable e) {
                out.setStatus(BLonLinkStatus.comError);
                return;
            }
            out.setStatus(BLonLinkStatus.bound);
            this.userUpdate();
        } else if (!this.groupTable.selectTagGroup(tagCnctn, this.offDevs)) {
            tagCnctn.setStatus(BLonLinkStatus.groupError);
        }
    }

    private void selectGroup() {
        for (int i = 0; i < this.table.length; ++i) {
            for (Connection cnctn = this.table[i]; cnctn != null; cnctn = cnctn.getSecondary()) {
                if (!cnctn.isActive() || cnctn.isError() || cnctn.isPollOnly()) continue;
                if (cnctn.getHub().isProxy()) {
                    cnctn.setAddressChange(false);
                    continue;
                }
                if (cnctn.getHub().isPseudo()) {
                    cnctn.clearAddressEntry();
                    continue;
                }
                if (this.debug) {
                    System.out.println("\nselect addressing for connection " + cnctn.getSelector());
                }
                if (cnctn.isTurnAroundAddressEntry()) {
                    if (this.groupTable.selectTurnAround(cnctn, this.offDevs)) continue;
                    cnctn.setStatus(BLonLinkStatus.groupError);
                    continue;
                }
                if (cnctn.getHub().isPolled()) {
                    LonPoint[] tgts = cnctn.getTargets();
                    for (int n = 0; n < tgts.length; ++n) {
                        if (tgts[n].isProxy() || !tgts[n].isActive()) continue;
                        this.groupTable.selectSingle(cnctn, tgts[n], this.offDevs);
                    }
                    continue;
                }
                LonPoint snTgt = cnctn.getSubnetNodeAddressTarget();
                if (snTgt != null && this.groupTable.selectSingle(cnctn, snTgt, this.offDevs) || this.groupTable.selectGroup(cnctn, this.offDevs)) continue;
                cnctn.setStatus(BLonLinkStatus.groupError);
            }
        }
    }

    private boolean processSnAddress(Connection connection) {
        LonPoint adrPnt = connection.getPntRequiringAddressEntry();
        if (adrPnt == null || adrPnt.isLocal() || adrPnt.isPseudo()) {
            return true;
        }
        try {
            BLonDevice dev = adrPnt.getLonDevice();
            this.updateAddressTable(dev, adrPnt.getAddressIndex());
        }
        catch (Throwable e) {
            adrPnt.setStatus(BLonLinkStatus.comError);
            this.error("Failed to update address in BLonBindJob.processSnAddress() " + adrPnt, e);
            return false;
        }
        this.userUpdate();
        return true;
    }

    private void updateAddressTable(BLonDevice dev, int index) throws Exception {
        if (Lon.n()) {
            NmUtil.setOfflineInBind(dev, this.offDevs);
            NmUtil.updateAddressTable(dev, index);
            if (!NmUtil.verifyAddressEntry(dev, index)) {
                this.error("ERROR: unable to verify address entry " + index + " in " + dev.getDisplayName(null), null);
            }
        }
    }

    private void processConnections() {
        for (int i = 0; i < this.table.length; ++i) {
            for (Connection cnctn = this.table[i]; cnctn != null; cnctn = cnctn.getSecondary()) {
                if (cnctn.isError() || cnctn.isPollOnly() || cnctn.getAddressGroup() < 0 && cnctn.isAddressChange() && !this.processSnAddress(cnctn)) continue;
                if (cnctn.isLocal()) {
                    this.processLocalConnection(cnctn);
                    continue;
                }
                this.processNetConnection(cnctn);
            }
        }
    }

    public void userUpdate() {
        if (++this.completes % 50 == 0) {
            this.incrementProgress(1, 80);
        }
    }

    private void removeObsolete() {
        for (int i = 0; i < this.table.length; ++i) {
            for (Connection c = this.table[i]; c != null; c = c.getSecondary()) {
                boolean isPollOnly = c.isPollOnly();
                LonPoint hub = c.getHub();
                if (hub != null && hub.requiresUnbind(isPollOnly)) {
                    this.unbind(hub);
                }
                LonPoint[] targets = c.getTargets();
                for (int x = 0; x < targets.length; ++x) {
                    if (!targets[x].requiresUnbind(isPollOnly)) continue;
                    this.unbind(targets[x]);
                }
            }
        }
    }

    private void processLocalConnection(Connection c) {
        int selector = c.getSelector();
        LonPoint hub = c.getHub();
        LonPoint[] targets = c.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            this.bind(targets[i], selector, c, false);
        }
        if (hub != null) {
            this.bind(hub, selector, c, !hub.isLocal());
        }
    }

    private void processNetConnection(Connection c) {
        int selector = c.getSelector();
        LonPoint hub = c.getHub();
        LonPoint[] targets = c.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            this.bind(targets[i], selector, c, false);
        }
        if (hub != null) {
            this.bind(hub, selector, c, false);
        }
    }

    private void bind(LonPoint lp, int selector, Connection conn, boolean localBind) {
        if (lp == null || lp.isObsolete() || lp.isUnbound() || lp.isError()) {
            return;
        }
        if (lp.isAliasPoint()) {
            this.bindAlias((LonPointAlias)lp, selector, conn);
            return;
        }
        if (lp.isPseudo()) {
            this.bindPseudo((LonPointPseudo)lp, selector, conn);
            return;
        }
        if (lp.isLocal()) {
            lp.setStatus(BLonLinkStatus.bound);
            return;
        }
        BNetworkVariable nv = lp.getNetworkVariable();
        BNvProps nvProps = nv.getNvProps();
        if (lp.isBound()) {
            if (nvProps.getBoundToLocal() != localBind) {
                nvProps.setBoundToLocal(localBind);
                nv.bound();
            }
            return;
        }
        BNvConfigData configData = nv.getNvConfigData();
        BNvConfigData origDat = (BNvConfigData)configData.newCopy(true);
        configData.setSelector(selector);
        configData.setAddrIndex(lp.getAddressIndex());
        configData.setAuthenticated(conn.isAuthenticated());
        configData.setServiceType(NmUtil.linkTypeToServiceType(conn.getLinkType()));
        configData.setPriority(conn.getPriority() && !configData.isInput());
        configData.setTurnAround(lp.isOutput() && conn.hasTurnAround());
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for LonPoint " + lp + "\nnvprops =>" + (Object)((Object)nv.getNvProps()));
        }
        BLonDevice dev = lp.getLonDevice();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(dev, this.offDevs);
                NmUtil.updateNvConfig(dev, nv.getNvIndex(), configData);
                if (!NmUtil.verifyNvConfig(dev, nv.getNvIndex(), configData)) {
                    this.error("Failed to verifyNvConfig in BLonBindJob.bind() " + lp, null);
                    configData.copyFrom((BComplex)origDat);
                    lp.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.error("Failed to update NV config in BLonBindJob.bind() " + lp, e);
            configData.copyFrom((BComplex)origDat);
            lp.setStatus(BLonLinkStatus.comError);
            return;
        }
        lp.setStatus(BLonLinkStatus.bound);
        nv.getNvProps().setBoundToLocal(localBind);
        if (!localBind && !configData.isInput() && nv.getData().hasProxies()) {
            System.out.println("INTERNAL ERROR : not local but has proxies for " + lp + "\n" + conn);
        }
        try {
            nv.bound();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.userUpdate();
    }

    private void bindPseudo(LonPointPseudo lp, int selector, Connection conn) {
        BPseudoNV nv = lp.pseudoNv;
        if (lp.isBound()) {
            return;
        }
        BNvConfigData configData = nv.getNvConfigData();
        configData.setSelector(selector);
        configData.setAddrIndex(lp.getAddressIndex());
        configData.setAuthenticated(conn.isAuthenticated());
        configData.setServiceType(NmUtil.linkTypeToServiceType(conn.getLinkType()));
        configData.setPriority(conn.getPriority() && !configData.isInput());
        configData.setTurnAround(lp.isOutput() && conn.hasTurnAround());
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for LonPoint " + lp + "\nnvprops =>" + (Object)((Object)nv.getNvProps()));
        }
        lp.setStatus(BLonLinkStatus.bound);
        this.userUpdate();
    }

    private void bindAlias(LonPointAlias lap, int selector, Connection conn) {
        if (lap == null || !lap.isNew()) {
            return;
        }
        BLonDevice dev = lap.getLonDevice();
        BAliasConfigData configData = dev.getDeviceData().getAliasTable().getAliasArray()[lap.getAliasIndex()];
        BAliasConfigData origDat = (BAliasConfigData)configData.newCopy(true);
        configData.setSelector(selector);
        configData.setAddrIndex(lap.getAddressIndex());
        configData.setAuthenticated(conn.isAuthenticated());
        configData.setServiceType(NmUtil.linkTypeToServiceType(conn.getLinkType()));
        configData.setPriority(conn.getPriority() && !configData.isInput());
        configData.setDirection(lap.getDirection());
        configData.setTurnAround(lap.isOutput() && conn.hasTurnAround());
        configData.setPrimary(lap.getPrimaryNvIndex());
        configData.setBound();
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for bindAlias " + lap + "\n  prim nvprops =>" + (Object)((Object)lap.getNvProps()));
        }
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(dev, this.offDevs);
                NmUtil.updateAliasConfig(dev, lap.getAliasIndex(), configData);
                if (!NmUtil.verifyAliasNvConfig(dev, lap.getAliasIndex(), configData)) {
                    lap.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.error("Failed to update NV config in BLonBindJob.bindAlias() " + lap, e);
            configData.copyFrom((BComplex)origDat);
            lap.setStatus(BLonLinkStatus.comError);
            return;
        }
        lap.setStatus(BLonLinkStatus.bound);
        this.userUpdate();
    }

    private void unbind(LonPoint lp) {
        if (lp.isAliasPoint()) {
            this.unbindAlias((LonPointAlias)lp);
            return;
        }
        if (this.debug) {
            System.out.print("\nunbind() for " + lp);
        }
        BNetworkVariable nv = lp.getNetworkVariable();
        BNvConfigData nvCfg = (BNvConfigData)lp.getNvConfigData().newCopy(true);
        nvCfg.setUnbound(nv.getNvIndex());
        BLonDevice dev = lp.getLonDevice();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(dev, this.offDevs);
                NmUtil.updateNvConfig(dev, nv.getNvIndex(), nvCfg);
                if (!NmUtil.verifyNvConfig(dev, nv.getNvIndex(), nvCfg)) {
                    lp.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.error("Failed to update NV config in BLonBindJob.unbind()" + lp, e);
            lp.setStatus(BLonLinkStatus.comError);
            return;
        }
        nv.setUnbound();
        lp.setStatus(BLonLinkStatus.unbound);
        this.userUpdate();
    }

    private void unbindAlias(LonPointAlias lap) {
        if (this.debug) {
            System.out.print("\nunbindAlias() for  " + lap);
        }
        BLonDevice dev = lap.getLonDevice();
        BAliasTable aliasTable = dev.getDeviceData().getAliasTable();
        BAliasConfigData configData = aliasTable.getAliasEntry(lap.getAliasIndex());
        BAliasConfigData origDat = (BAliasConfigData)configData.newCopy(true);
        configData.clearData();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(dev, this.offDevs);
                NmUtil.updateAliasConfig(dev, lap.getAliasIndex(), configData);
                if (!NmUtil.verifyAliasNvConfig(dev, lap.getAliasIndex(), configData)) {
                    lap.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.error("Failed to update NV config in BLonBindJob.unbindAlias()" + lap, e);
            configData.copyFrom((BComplex)origDat);
            lap.setStatus(BLonLinkStatus.comError);
            return;
        }
        lap.setStatus(BLonLinkStatus.unbound);
        this.userUpdate();
    }

    private void verifyChannelPriorities() {
        BLonDevice dev;
        BLonDevice[] lonDevices = this.adrMan.getDeviceList(false);
        Vector<BLonDevice> needPriority = new Vector<BLonDevice>();
        Vector<BLonDevice> delPriority = new Vector<BLonDevice>();
        for (int i = 0; i < lonDevices.length; ++i) {
            dev = lonDevices[i];
            boolean needsPrioritySlot = false;
            BINetworkVariable[] nvs = dev.getNetworkVariables();
            for (int n = 0; n < nvs.length; ++n) {
                if (nvs[n] == null || !nvs[n].isNetworkVariable() || !((BNetworkVariable)nvs[n]).requiresPrioritySlot()) continue;
                needsPrioritySlot = true;
                break;
            }
            if (needsPrioritySlot) {
                needPriority.addElement(dev);
                lonDevices[i] = null;
            }
            if (needsPrioritySlot == (dev.getDeviceData().getPrioritySlot() != 0) || needsPrioritySlot) continue;
            delPriority.addElement(dev);
            lonDevices[i] = null;
        }
        try {
            int i;
            int numPriorities = needPriority.size();
            int numDeletes = delPriority.size();
            for (i = 0; i < numPriorities; ++i) {
                dev = (BLonDevice)needPriority.elementAt(i);
                dev.getDeviceData().setPrioritySlot(i + 1);
                Neuron.setNodePriorityInfo(dev, i + 1, numPriorities);
            }
            for (i = 0; i < numDeletes; ++i) {
                dev = (BLonDevice)delPriority.elementAt(i);
                dev.getDeviceData().setPrioritySlot(0);
                Neuron.setNodePriorityInfo(dev, 0, numPriorities);
            }
            if (numPriorities != this.netMgmt.getChannelPriorities()) {
                this.netMgmt.setChannelPriorities(numPriorities);
                for (i = 0; i < lonDevices.length; ++i) {
                    dev = lonDevices[i];
                    if (dev == null || dev.getDeviceData().getFreezeChannelPriorities()) continue;
                    Neuron.setNodePriorityInfo(dev, 0, numPriorities);
                }
            }
        }
        catch (LonException e) {
            System.out.println("\n com failure in BLonBindJob.verifyChannelPriorities()" + (Object)((Object)e));
            return;
        }
    }
}

