/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.datatypes.BLinkFilterEntry;
import com.tridium.lonworks.datatypes.BLinkFilterTable;
import com.tridium.lonworks.loncomm.ListenerSupport;
import com.tridium.lonworks.loncomm.LonLinkListenerRegistry;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLinkFilter
extends BComponent
implements LonLinkListenerRegistry.LinkListener {
    public static final Property enableSubnetNode = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property subnetNode = BLinkFilter.newProperty((int)0, (BValue)BSubnetNode.DEFAULT, null);
    public static final Property enableDevice = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property deviceName = BLinkFilter.newProperty((int)0, (String)"", null);
    public static final Property enableSelector = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property selector = BLinkFilter.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)16383)));
    public static final Property maxEntries = BLinkFilter.newProperty((int)0, (int)1000, null);
    public static final Property entries = BLinkFilter.newProperty((int)7, (BValue)new BLinkFilterTable(), null);
    public static final Property toStandardOut = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Property includeCompletionEvents = BLinkFilter.newProperty((int)0, (boolean)false, null);
    public static final Action clearTable = BLinkFilter.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLinkFilter.class);
    LonLinkListenerRegistry llink = null;
    BLonDevice dev = null;
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/linkFilter.png");

    public boolean getEnableSubnetNode() {
        return this.getBoolean(enableSubnetNode);
    }

    public void setEnableSubnetNode(boolean v) {
        this.setBoolean(enableSubnetNode, v, null);
    }

    public BSubnetNode getSubnetNode() {
        return (BSubnetNode)this.get(subnetNode);
    }

    public void setSubnetNode(BSubnetNode v) {
        this.set(subnetNode, (BValue)v, null);
    }

    public boolean getEnableDevice() {
        return this.getBoolean(enableDevice);
    }

    public void setEnableDevice(boolean v) {
        this.setBoolean(enableDevice, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public boolean getEnableSelector() {
        return this.getBoolean(enableSelector);
    }

    public void setEnableSelector(boolean v) {
        this.setBoolean(enableSelector, v, null);
    }

    public int getSelector() {
        return this.getInt(selector);
    }

    public void setSelector(int v) {
        this.setInt(selector, v, null);
    }

    public int getMaxEntries() {
        return this.getInt(maxEntries);
    }

    public void setMaxEntries(int v) {
        this.setInt(maxEntries, v, null);
    }

    public BLinkFilterTable getEntries() {
        return (BLinkFilterTable)this.get(entries);
    }

    public void setEntries(BLinkFilterTable v) {
        this.set(entries, (BValue)v, null);
    }

    public boolean getToStandardOut() {
        return this.getBoolean(toStandardOut);
    }

    public void setToStandardOut(boolean v) {
        this.setBoolean(toStandardOut, v, null);
    }

    public boolean getIncludeCompletionEvents() {
        return this.getBoolean(includeCompletionEvents);
    }

    public void setIncludeCompletionEvents(boolean v) {
        this.setBoolean(includeCompletionEvents, v, null);
    }

    public void clearTable() {
        this.invoke(clearTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getLinkLayer().registerLinkListener(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getLinkLayer().unregisterLinkListener(this);
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        this.dev = null;
    }

    public void doClearTable() {
        this.getEntries().clearEntries();
    }

    @Override
    public void receive(NAppBuffer msg) {
        if (this.passFilter(msg, true)) {
            this.display(msg, true);
        }
    }

    @Override
    public void send(NAppBuffer msg) {
        if (this.passFilter(msg, false)) {
            this.display(msg, false);
        }
    }

    private boolean passFilter(NAppBuffer msg, boolean rcv) {
        if (this.isCompletionEvent(msg) && !this.getIncludeCompletionEvents()) {
            return false;
        }
        boolean pass = false;
        if (this.getEnableSubnetNode()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByAddress(this.getSubnetNode());
            }
            if (!this.passDeviceFilter(this.dev, msg, rcv)) {
                return false;
            }
            pass = true;
        }
        if (this.getEnableDevice()) {
            if (this.dev == null) {
                this.dev = NmUtil.getLonNetwork(this).addressManager().getDeviceByName(this.getDeviceName());
            }
            if (!this.passDeviceFilter(this.dev, msg, rcv)) {
                return false;
            }
            pass = true;
        }
        if (this.getEnableSelector()) {
            if (msg.getMessageCode() < 128) {
                return false;
            }
            byte[] a = msg.getWriteBuffer();
            int sel = (a[16] & 0x3F) << 8 | a[17] & 0xFF;
            if (sel != this.getSelector()) {
                return false;
            }
            pass = true;
        }
        return pass;
    }

    private boolean isCompletionEvent(NAppBuffer msg) {
        return msg.isCompletionEvent() && !msg.isResp();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean passDeviceFilter(BLonDevice dev, NAppBuffer msg, boolean rcv) {
        if (dev == null) {
            return false;
        }
        if (!rcv || this.isCompletionEvent(msg)) {
            byte[] buf = msg.getReadBuffer();
            byte typ = buf[5];
            if (typ == 1) {
                BSubnetNode sn = BSubnetNode.make(buf[9], buf[6] & 0x7F);
                if (sn.equals(dev.getSubnetNodeAddress())) return true;
                return false;
            }
            if (typ != 2) return false;
            byte[] na = new byte[6];
            System.arraycopy(buf, 10, na, 0, 6);
            BNeuronId nid = BNeuronId.make(na);
            if (nid.equals(dev.getNeuronIdAddress())) return true;
            return false;
        }
        BSubnetNode sn = msg.getSourceAddress();
        if (sn.equals(dev.getSubnetNodeAddress())) return true;
        return false;
    }

    private void display(NAppBuffer msg, boolean rcv) {
        if (this.getToStandardOut()) {
            this.toStandardOut(msg, rcv);
            return;
        }
        BLinkFilterTable et = this.getEntries();
        if (et.getMaxIndex() >= this.getMaxEntries()) {
            return;
        }
        BAbsTime ts = BAbsTime.make((long)System.currentTimeMillis());
        BBlob bl = BBlob.make((byte[])msg.getReadBuffer(), (int)0, (int)msg.getWriteBufferLen());
        this.getEntries().addEntry(new BLinkFilterEntry(rcv, ts, bl));
    }

    private void toStandardOut(NAppBuffer msg, boolean rcv) {
        byte[] a = msg.getWriteBuffer();
        if (rcv) {
            this.getLinkLayer().writeLinkDebug("recv: ", a, a[1] + 2);
        } else {
            this.getLinkLayer().writeLinkDebug("send: ", a, a[1] + 2);
        }
    }

    LonLinkListenerRegistry getLinkLayer() {
        LonLinkLayer lnk;
        if (this.llink == null && (lnk = ((NLonComm)NmUtil.getLonNetwork((BComponent)this).lonComm()).linkLayer) instanceof ListenerSupport) {
            this.llink = ((ListenerSupport)((Object)lnk)).getLonLinkListenerRegistry();
        }
        return this.llink;
    }

    public BIcon getIcon() {
        return icon;
    }
}

