/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.local;

import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import com.tridium.lonworks.xml.XTypeDef;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BLocalImportXmlParameter;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class LocalDev {
    public static void importXLon(BLocalLonDevice ld, BLocalImportXmlParameter p) {
        boolean leave = false;
        boolean remove = false;
        try {
            int i;
            BOrd ord = p.getFile();
            XLonInterfaceFile root = LonXMLReader.decode(ord);
            BDynamicDevice dynDev = new BDynamicDevice();
            DynaDev.importXLon(dynDev, root, null);
            Context tx = Transaction.start((BComponent)ld, (Context)BLocalLonDevice.noInfoChange);
            XLonDevice dev = root.getLonDevice();
            ld.setSelfDoc(dev.deviceData.nodeSelfID);
            BINetworkVariable[] curNvs = ld.getNetworkVariables();
            BINetworkVariable[] newNvs = dynDev.getNetworkVariables();
            XNetworkVariable[] xnvs = dev.getNetworkVariables();
            XNetworkConfig[] xncs = dev.getNetworkConfigs();
            for (i = 0; i < curNvs.length; ++i) {
                if (curNvs[i] == null) continue;
                if (i >= newNvs.length || newNvs[i] == null || !LocalDev.isEquivalent(newNvs[i], curNvs[i])) {
                    ld.remove(((BComponent)curNvs[i]).getPropertyInParent(), tx);
                    remove = true;
                    continue;
                }
                if (i >= newNvs.length) continue;
                newNvs[i] = null;
                leave = true;
            }
            for (i = 0; i < newNvs.length; ++i) {
                if (newNvs[i] == null) continue;
                if (newNvs[i].isNetworkVariable()) {
                    BNetworkVariable nv = (BNetworkVariable)newNvs[i];
                    BLocalNv lnv = new BLocalNv();
                    lnv.getNvProps().copyFrom((BComplex)nv.getNvProps());
                    lnv.getNvConfigData().copyFrom((BComplex)nv.getNvConfigData());
                    lnv.getNvConfigData().setUnbound(lnv.getNvProps().getNvIndex());
                    lnv.setSelfDoc(LocalDev.getSelfDoc(LocalDev.getNv(xnvs, i)));
                    LocalDev.setData(nv, lnv);
                    ld.add(nv.getName(), (BValue)lnv, tx);
                    continue;
                }
                if (!newNvs[i].isNetworkConfig()) continue;
                BNetworkConfig nc = (BNetworkConfig)newNvs[i];
                BLocalNci lnc = new BLocalNci();
                lnc.getNcProps().copyFrom((BComplex)nc.getNcProps());
                lnc.getNvConfigData().copyFrom((BComplex)nc.getNvConfigData());
                lnc.setSelfDoc(LocalDev.getSelfDoc(LocalDev.getNci(xncs, i), root));
                LocalDev.setData(nc, lnc);
                ld.add(nc.getName(), (BValue)lnc, tx);
            }
            Transaction.end((BComponent)ld, (Context)tx);
            if (remove && leave) {
                LocalDev.reorder(ld);
            }
        }
        catch (Throwable e) {
            ld.lonNetwork().log().log(Level.SEVERE, "Error importing xml.", e);
        }
    }

    private static String getSelfDoc(XNetworkVariable xnv) {
        if (xnv == null || xnv.memberIndex < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("@").append(xnv.objectIndex);
        sb.append(xnv.mfgMember ? "#" : "|");
        sb.append(Integer.toString(xnv.memberIndex));
        if (xnv.memberArraySize > 1) {
            sb.append("[").append(Integer.toString(xnv.memberArraySize)).append("]");
        }
        return sb.toString();
    }

    private static String getSelfDoc(XNetworkConfig xnc, XLonInterfaceFile root) {
        int typNdx;
        int scope;
        if (xnc == null) {
            return "";
        }
        if (xnc.scptType.length() > 0) {
            scope = 0;
            typNdx = XLonDataUtil.scptTypeFromString(xnc.scptType);
        } else if (xnc.typeDef.length() > 0) {
            XTypeDef xTypDef = root.resolveTypeDef(xnc.typeDef);
            if (xTypDef == null) {
                return "";
            }
            String typScp = xTypDef.typeScope;
            if (typScp.length() == 0) {
                return "";
            }
            scope = Integer.parseInt(typScp.substring(0, typScp.indexOf(44)));
            typNdx = Integer.parseInt(typScp.substring(typScp.indexOf(44) + 1));
        } else {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("&").append(XLonDataUtil.scopeFromString(xnc.scope)).append(",");
        sb.append(xnc.select).append(",");
        sb.append(Integer.toString(scope)).append("\\x");
        sb.append(Integer.toString(XLonDataUtil.flagFromString(xnc.modifyFlag), 16)).append(",");
        sb.append(Integer.toString(typNdx)).append(";");
        return sb.toString();
    }

    private static XNetworkVariable getNv(XNetworkVariable[] nvs, int ndx) {
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i] == null || nvs[i].index != ndx) continue;
            return nvs[i];
        }
        return null;
    }

    private static XNetworkConfig getNci(XNetworkConfig[] ncs, int ndx) {
        for (int i = 0; i < ncs.length; ++i) {
            if (ncs[i] == null || ncs[i].index > ndx || ndx > ncs[i].getMaxIndex()) continue;
            return ncs[i];
        }
        return null;
    }

    private static boolean isEquivalent(BINetworkVariable inv1, BINetworkVariable inv2) {
        if (!inv1.getName().equals(inv2.getName())) {
            return false;
        }
        if (!inv1.getNvConfigData().getDirection().equals((Object)inv2.getNvConfigData().getDirection())) {
            return false;
        }
        if (inv1.isNetworkVariable() && inv2.isLocalNv()) {
            if (!((BNetworkVariable)inv1).getNvProps().equivalent((Object)((BLocalNv)inv2).getNvProps())) {
                return false;
            }
        } else if (inv1.isNetworkConfig() && inv2.isLocalNci()) {
            if (!((BNetworkConfig)inv1).getNcProps().equivalent((Object)((BLocalNci)inv2).getNcProps())) {
                return false;
            }
        } else {
            return false;
        }
        return inv1.getData().hasEquivalentElements(inv2.getData());
    }

    private static void setData(BLonData src, BLonComponent dest) {
        Property[] psrc = src.getPropertiesArray();
        for (int i = 0; i < psrc.length; ++i) {
            Property p = psrc[i];
            BValue v = src.get(p);
            if (!(v instanceof BLonPrimitive) && !(v instanceof BLonData)) continue;
            dest.add(p.getName(), v, p.getDefaultFlags(), p.getFacets(), null);
        }
    }

    private static void reorder(BLocalLonDevice ld) {
        ArrayList<Property> v = new ArrayList<Property>();
        SlotCursor c = ld.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (p.isFrozen()) continue;
            v.add(p);
        }
        int len = v.size();
        Object[] a = v.toArray(new Property[len]);
        Object[] keys = new String[len];
        for (int i = 0; i < len; ++i) {
            BValue bo = ld.get(a[i]);
            keys[i] = bo.getType().is(BINetworkVariable.TYPE) ? LocalDev.getKey("b", ((BINetworkVariable)bo).getNvIndex()) : LocalDev.getKey("z", i);
        }
        SortUtil.sort((Object[])keys, (Object[])a, (boolean)true);
        ld.reorder((Property[])a);
    }

    private static String getKey(String prefix, int index) {
        String i = Integer.toString(index);
        return prefix + TextUtil.getSpaces((int)(5 - i.length())) + i;
    }
}

