/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.qnx;

import com.tridium.hdk8000.Hdk8000;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.platSerial.qnx.BSerialPortQnx;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialPortPlatformServiceQnx
extends BSerialPortPlatformService {
    public static final Type TYPE = Sys.loadType(BSerialPortPlatformServiceQnx.class);
    private boolean nativesLoaded = false;
    public static final String SERIAL_PORT_PREFIX = "COM";
    public static final int NUM_U_MAP_SPACE_DELIMITED_FIELDS = 10;
    public static final int NUM_U_MAP_PAREN_DELIMITED_FIELDS = 2;
    protected final Comparator<String> SERIAL_PORT_COMPARATOR = (port1Name, port2Name) -> {
        if (port1Name.indexOf(SERIAL_PORT_PREFIX) == 0 && port2Name.indexOf(SERIAL_PORT_PREFIX) == 0) {
            int port2Id;
            int port1Id = Integer.parseInt(port1Name.substring(SERIAL_PORT_PREFIX.length()));
            if (port1Id < (port2Id = Integer.parseInt(port2Name.substring(SERIAL_PORT_PREFIX.length())))) {
                return -1;
            }
            if (port1Id == port2Id) {
                return 0;
            }
            return 1;
        }
        return port1Name.compareTo((String)port2Name);
    };

    public Type getType() {
        return TYPE;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading serial native library");
                System.loadLibrary("serial");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load serial native library", e);
            }
            return this.nativesLoaded;
        });
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    public int getSlotFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] loadPortIdentifiers() {
        int i;
        this.loadLibraries();
        Object[] slotNames = new String[]{};
        BSerialPortQnx[] ports = new BSerialPortQnx[]{};
        log.fine("Loading comm port identifiers...");
        if (Nre.getHostModel().equalsIgnoreCase("titan")) {
            BufferedReader br = this.accessFile("/tmp/u_map_error", false);
            if (br != null) {
                try {
                    String err = br.readLine();
                    log.severe("***** Unable to initialise serial platform: *****\n\t" + err);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
            if ((br = this.accessFile("/tmp/u_map", true)) == null) {
                return null;
            }
            ArrayList<String> slotNamesAR = new ArrayList<String>();
            ArrayList<BSerialPortQnx> portAR = new ArrayList<BSerialPortQnx>();
            Hdk8000 whitelist = new Hdk8000();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith(SERIAL_PORT_PREFIX)) continue;
                    int vendorParenStart = line.indexOf(" (");
                    String vendorStr = this.extractFromParens(vendorParenStart, line);
                    int vendorStrEnd = line.indexOf(vendorStr) + vendorStr.length() + 2;
                    String productStr = this.extractFromParens(vendorStrEnd, line);
                    String infoLine = line.substring(0, vendorParenStart - 1);
                    StringTokenizer st = new StringTokenizer(infoLine);
                    if (st.countTokens() != 10) {
                        log.severe("Unexpected u_map format, cannot enumerate serial ports");
                        String[] stringArray = null;
                        return stringArray;
                    }
                    String name = st.nextToken();
                    String osName = st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    int position = Integer.parseInt(st.nextToken());
                    String vendorId = st.nextToken();
                    String productId = st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    log.fine("Validating " + vendorId + ":" + productId + ":" + vendorStr + ":" + productStr);
                    if (!whitelist.validatePort(vendorId, productId, vendorStr, productStr)) {
                        log.warning("Non approved USB expansion device, ven=" + vendorStr + " prod=" + productStr);
                        continue;
                    }
                    log.fine("Validated " + vendorId + ":" + productId + ":" + vendorStr + ":" + productStr);
                    int ndx = Integer.parseInt(name.substring(SERIAL_PORT_PREFIX.length()));
                    portAR.add(new BSerialPortQnx(osName, ndx, position, vendorStr, productStr));
                    slotNamesAR.add(SERIAL_PORT_PREFIX + ndx);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            ports = portAR.toArray(ports);
            slotNames = (String[])slotNamesAR.toArray(slotNames);
        } else if (Nre.getHostModel().equalsIgnoreCase("edge10")) {
            boolean serial_port_exists = AccessController.doPrivileged(() -> {
                File file = new File("/dev/ser1");
                return file.exists();
            });
            if (serial_port_exists) {
                ports = new BSerialPortQnx[]{new BSerialPortQnx("/dev/ser1", 1)};
                slotNames = new String[]{"COM1"};
            } else {
                ports = new BSerialPortQnx[]{};
                slotNames = new String[]{};
            }
        } else {
            File devDir = new File("/dev");
            String[] files = AccessController.doPrivileged(devDir::list);
            String serPrefix = "ser";
            int count = 0;
            for (i = 0; i < files.length; ++i) {
                if (!files[i].startsWith(serPrefix) || files[i].equals("serconsole")) continue;
                ++count;
            }
            log.fine("Found " + count + " serial ports");
            ports = new BSerialPortQnx[count];
            slotNames = new String[count];
            count = 0;
            for (i = 0; i < files.length; ++i) {
                int index;
                if (!files[i].startsWith(serPrefix) || files[i].equals("serconsole")) continue;
                if (files[i].startsWith("sergprs")) {
                    index = Integer.parseInt(files[i].substring(7));
                    ports[count] = new BSerialPortQnx("/dev/" + files[i], index);
                    slotNames[count] = "COMGPRS" + index;
                    ++count;
                    continue;
                }
                index = Integer.parseInt(files[i].substring(serPrefix.length()));
                ports[count] = new BSerialPortQnx("/dev/" + files[i], index);
                slotNames[count] = SERIAL_PORT_PREFIX + index;
                log.fine("Created " + (String)slotNames[count]);
                ++count;
            }
        }
        SortUtil.sort((Object[])slotNames, (Object[])ports, this.SERIAL_PORT_COMPARATOR);
        for (i = 0; i < slotNames.length; ++i) {
            this.add(SlotPath.escape((String)slotNames[i]), (BValue)ports[i], 3);
        }
        return slotNames;
    }

    private String extractFromParens(int startNdx, String line) {
        StringCharacterIterator characterIterator = new StringCharacterIterator(line, startNdx, line.length(), startNdx);
        char c = characterIterator.first();
        int leftParenCount = 0;
        boolean reading = false;
        StringBuilder sb = new StringBuilder();
        while (c != '\uffff') {
            if (c == '(') {
                if (++leftParenCount == 1) {
                    reading = true;
                    c = characterIterator.next();
                    continue;
                }
            } else if (c == ')' && leftParenCount > 0 && --leftParenCount == 0) break;
            if (reading) {
                sb.append(c);
            }
            c = characterIterator.next();
        }
        return sb.toString();
    }

    private BufferedReader accessFile(String fileName, boolean reportError) {
        BufferedReader br;
        block2: {
            br = null;
            try {
                br = AccessController.doPrivileged(() -> new BufferedReader(new FileReader(fileName)));
            }
            catch (PrivilegedActionException e) {
                if (!reportError) break block2;
                e.printStackTrace();
            }
        }
        return br;
    }
}

