/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall.util;

import com.tridium.oncall.BOnCallContact;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallSchedule;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.BOnCallContactUserEventInfo;
import com.tridium.oncall.util.OnCallToolkit;
import java.util.HashSet;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public final class ReportUtil {
    public static BComponent createUserReport(BComponent info, Context cx) throws Exception {
        BOnCallService srv = BOnCallService.getInstance();
        BComponent comp = (BComponent)((BOrd)info.get("ord")).get((BObject)srv);
        BUser user = null;
        if (comp instanceof BUser) {
            user = (BUser)comp;
        } else if (comp instanceof BOnCallContact) {
            user = (BUser)((BOnCallContact)comp).getUser().get((BObject)srv);
        } else {
            throw new Exception("Unsupported export: " + comp.getType());
        }
        BITable coll = (BITable)BOrd.make((String)("slot:|bql:select from onCall:OnCallContact where status.isOk and user like '" + user.getHandleOrd() + "'")).get((BObject)srv);
        TableCursor c = coll.cursor();
        HashSet<BComplex> set = new HashSet<BComplex>();
        while (c.next()) {
            set.add(((BOnCallContact)c.get()).getParent());
        }
        Object[] objs = set.toArray();
        BOnCallList[] lists = new BOnCallList[objs.length];
        System.arraycopy(objs, 0, lists, 0, objs.length);
        if (OnCallToolkit.log.isTraceOn()) {
            for (int i = 0; i < lists.length; ++i) {
                OnCallToolkit.log.trace("Found On Call List: " + SlotPath.unescape((String)lists[i].toPathString()));
            }
        }
        BOnCallRecipient[] recs = srv.getOnCallRecipients();
        BAbsTime newStart = BAbsTime.make((BAbsTime)((BAbsTime)info.get("start")), (BTime)BTime.MIDNIGHT);
        BAbsTime newEnd = BAbsTime.make((BAbsTime)((BAbsTime)info.get("end")).nextDay(), (BTime)BTime.MIDNIGHT);
        Array events = new Array(BOnCallContactUserEventInfo.class);
        for (int i = 0; i < lists.length; ++i) {
            for (int j = 0; j < recs.length; ++j) {
                ReportUtil.searchSchedule(user, recs[j].getOnCallListSchedule(), lists[i], newStart, newEnd, (Array<BOnCallContactUserEventInfo>)events, cx);
            }
        }
        BComponent result = new BComponent();
        result.add("userName", (BValue)BString.make((String)user.getDisplayName(cx)));
        BOnCallContactUserEventInfo[] evs = (BOnCallContactUserEventInfo[])events.sort().trim();
        for (int i = 0; i < evs.length; ++i) {
            result.add(null, (BValue)evs[i]);
        }
        return result;
    }

    private static void searchSchedule(BUser user, BOnCallSchedule schedule, BOnCallList list, BAbsTime start, BAbsTime end, Array<BOnCallContactUserEventInfo> events, Context cx) {
        BAbsTime day = start;
        BAbsTime nextDay = day.nextDay();
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Starting schedule search -> " + SlotPath.unescape((String)schedule.toPathString()));
        }
        while (day.isBefore(end)) {
            String pl;
            BStatusEnum val;
            BAbsTime last = null;
            BAbsTime next = day;
            while (true) {
                last = next;
                if ((next = schedule.nextEvent(next)) == null || next.isAfter(nextDay) || next.equals((Object)nextDay)) break;
                val = (BStatusEnum)schedule.getOutput(last);
                if (val.getStatus().isNull() || val.getValue().getOrdinal() != list.getOrdinal()) continue;
                if (OnCallToolkit.log.isTraceOn()) {
                    OnCallToolkit.log.trace("Found start: " + last + " day: " + last.getWeekday() + " val: " + schedule.getOutput(last));
                    OnCallToolkit.log.trace("Found end:   " + next + " day: " + next.getWeekday());
                    OnCallToolkit.log.trace("Effective: " + schedule.isEffective(last) + "\n");
                }
                if ((pl = list.getPriorityList(user.getHandleOrd())).length() <= 0) continue;
                events.add((Object)new BOnCallContactUserEventInfo(schedule.getOnCallRecipient(), list, pl, last, next, cx));
            }
            next = BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
            val = (BStatusEnum)schedule.getOutput(last);
            if (!val.getStatus().isNull() && val.getValue().getOrdinal() == list.getOrdinal()) {
                if (OnCallToolkit.log.isTraceOn()) {
                    OnCallToolkit.log.trace("Found start: " + last + " day: " + last.getWeekday() + " val: " + schedule.getOutput(last));
                    OnCallToolkit.log.trace("Found end:   " + next + " day: " + next.getWeekday());
                    OnCallToolkit.log.trace("Effective: " + schedule.isEffective(last) + "\n");
                }
                if ((pl = list.getPriorityList(user.getHandleOrd())).length() > 0) {
                    events.add((Object)new BOnCallContactUserEventInfo(schedule.getOnCallRecipient(), list, pl, last, next, cx));
                }
            }
            day = nextDay;
            nextDay = nextDay.nextDay();
        }
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Finished schedule search");
        }
    }
}

