/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.AlarmUtil;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.oncall.BOnCallSchedule;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public final class BOnCallRecipient
extends BAlarmRecipient {
    public static final Property enabled = BOnCallRecipient.newProperty((int)8, (BValue)new BStatusBoolean(true), null);
    public static final Property onCallList = BOnCallRecipient.newProperty((int)11, (String)"", null);
    public static final Property onCallListSchedule = BOnCallRecipient.newProperty((int)0, (BValue)new BOnCallSchedule(), null);
    public static final Property escalationDelay = BOnCallRecipient.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property checkEscalationDelay = BOnCallRecipient.newProperty((int)4, (BValue)BRelTime.makeMinutes((int)3), null);
    public static final Action handleAlarm = BOnCallRecipient.newAction((int)20, (BValue)new BAlarmRecord(), null);
    public static final Action checkEscalation = BOnCallRecipient.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BOnCallRecipient.class);
    private Object checkMon = new Object();
    private Clock.Ticket checkTicket = null;

    public BStatusBoolean getEnabled() {
        return (BStatusBoolean)this.get(enabled);
    }

    public void setEnabled(BStatusBoolean v) {
        this.set(enabled, (BValue)v, null);
    }

    public String getOnCallList() {
        return this.getString(onCallList);
    }

    public void setOnCallList(String v) {
        this.setString(onCallList, v, null);
    }

    public BOnCallSchedule getOnCallListSchedule() {
        return (BOnCallSchedule)this.get(onCallListSchedule);
    }

    public void setOnCallListSchedule(BOnCallSchedule v) {
        this.set(onCallListSchedule, (BValue)v, null);
    }

    public BRelTime getEscalationDelay() {
        return (BRelTime)this.get(escalationDelay);
    }

    public void setEscalationDelay(BRelTime v) {
        this.set(escalationDelay, (BValue)v, null);
    }

    public BRelTime getCheckEscalationDelay() {
        return (BRelTime)this.get(checkEscalationDelay);
    }

    public void setCheckEscalationDelay(BRelTime v) {
        this.set(checkEscalationDelay, (BValue)v, null);
    }

    public void handleAlarm(BAlarmRecord record) {
        this.invoke(handleAlarm, (BValue)record, null);
    }

    public void checkEscalation() {
        this.invoke(checkEscalation, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BOnCallService.getInstance().registerOnCallRecipient(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void descendantsStarted() throws Exception {
        Object object = this.checkMon;
        synchronized (object) {
            if (this.checkTicket != null) {
                this.checkTicket.cancel();
            }
            this.checkTicket = Clock.schedule((BComponent)this, (BRelTime)this.getCheckEscalationDelay(), (Action)checkEscalation, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Object object = this.checkMon;
        synchronized (object) {
            if (this.checkTicket != null) {
                this.checkTicket.cancel();
                this.checkTicket = null;
            }
        }
        BOnCallService.getInstance().unregisterOnCallRecipient(this);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == checkEscalation || action == handleAlarm) {
            return BOnCallService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        if (targetSlot != routeAlarm) {
            return LinkCheck.makeValid();
        }
        if (!(source instanceof BAlarmClass) && sourceSlot != BAlarmClass.alarm) {
            return LinkCheck.makeInvalid((String)Lexicon.make((BModule)Sys.getModuleForClass(((Object)((Object)this)).getClass()), (Context)cx).getText("linkCheck.notLinkedToAlarmClass"));
        }
        Knob[] knobs = source.getKnobs((Slot)BAlarmClass.alarm);
        boolean foundOnCallRecipient = false;
        for (int i = 0; i < knobs.length; ++i) {
            if (!(knobs[i].getTargetOrd().get((BObject)this) instanceof BOnCallRecipient)) continue;
            foundOnCallRecipient = true;
            break;
        }
        if (foundOnCallRecipient) {
            return LinkCheck.makeInvalid((String)Lexicon.make((BModule)Sys.getModuleForClass(((Object)((Object)this)).getClass()), (Context)cx).getText("linkCheck.onlyLinkAlarmClassToOneOnCallRecipient"));
        }
        return LinkCheck.makeValid();
    }

    public void added(Property property, Context context) {
        BLink link;
        if (this.isRunning() && property.getType().is(BLink.TYPE) && (link = (BLink)this.get(property)).getTargetSlotName().equals(routeAlarm.getName())) {
            this.getOnCallListSchedule().clearAndEscalate(BString.DEFAULT);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        BLink link;
        BObject o;
        if (this.isRunning() && property.getType().is(BLink.TYPE) && (o = (link = (BLink)oldValue).getSourceOrd().get((BObject)this)) instanceof BAlarmClass && link.getTargetSlotName().equals(routeAlarm.getName())) {
            this.getOnCallListSchedule().clearAndEscalate(BString.make((String)o.asComplex().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        if (this.isRunning() && property == checkEscalationDelay) {
            Object object = this.checkMon;
            synchronized (object) {
                if (this.checkTicket != null) {
                    this.checkTicket.cancel();
                }
                this.checkTicket = Clock.schedule((BComponent)this, (BRelTime)this.getCheckEscalationDelay(), (Action)checkEscalation, null);
            }
        }
    }

    public void doHandleAlarm(BAlarmRecord record) {
        BStatusBoolean enabledStat = this.getEnabled();
        if (enabledStat.getStatus().isNull()) {
            return;
        }
        if (!enabledStat.getValue()) {
            return;
        }
        if (BOnCallService.getInstance().isFatalFault()) {
            return;
        }
        if (record.isAcknowledged()) {
            return;
        }
        this.getOnCallListSchedule().routeAlarm(record, this);
    }

    BConsoleRecipient[] getLinkedConsoleRecipients() {
        return (BConsoleRecipient[])this.getLinkedComponents(BConsoleRecipient.TYPE);
    }

    BStationRecipient[] getLinkedStationRecipients() {
        return (BStationRecipient[])this.getLinkedComponents(BStationRecipient.TYPE);
    }

    private Object[] getLinkedComponents(Type t) {
        Array ar = new Array(t.getTypeClass());
        BLink[] links = this.getLinks((Slot)routeAlarm);
        for (int i = 0; i < links.length; ++i) {
            if (!(links[i].getSourceComponent() instanceof BAlarmClass)) continue;
            BAlarmClass cls = (BAlarmClass)links[i].getSourceComponent();
            Knob[] knobs = cls.getKnobs((Slot)BAlarmClass.alarm);
            for (int j = 0; j < knobs.length; ++j) {
                if (!knobs[j].getTargetComponent().getType().is(t)) continue;
                ar.add((Object)knobs[j].getTargetComponent());
            }
        }
        return ar.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckEscalation() {
        try {
            if (!BOnCallService.getInstance().isFatalFault()) {
                this.getOnCallListSchedule().checkEscalation(this);
            }
        }
        catch (Exception e) {
            OnCallToolkit.log.error("Checking escalation", (Throwable)e);
        }
        finally {
            Object object = this.checkMon;
            synchronized (object) {
                if (this.checkTicket != null) {
                    this.checkTicket.cancel();
                }
                this.checkTicket = Clock.schedule((BComponent)this, (BRelTime)this.getCheckEscalationDelay(), (Action)checkEscalation, null);
            }
        }
    }

    String buildAlarmClassPredicate() {
        return this.buildAlarmClassPredicate("");
    }

    String buildAlarmClassPredicate(String extraAlarmClass) {
        String alarmClasses = AlarmUtil.make((BAlarmService)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE))).getInitialAlarmQuery((BAlarmRecipient)this);
        StringBuilder builder = new StringBuilder(alarmClasses);
        if (!extraAlarmClass.isEmpty()) {
            builder.append(" or (alarmClass='");
            builder.append(extraAlarmClass);
            builder.append("')");
        }
        return builder.toString();
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startTable(true);
            out.w((Object)"<tr>").th((Object)"On Call List").th((Object)"On Call Contact").th((Object)"On Call Priority").th((Object)"Start Time").th((Object)"End Time").th((Object)"Remaining").th((Object)"Source").th((Object)"State").th((Object)"Uuid").w((Object)"</tr>\n");
            String alarmPredicate = this.buildAlarmClassPredicate();
            String alarmQuery = alarmPredicate + "and not isAcknowledged";
            BITable coll = (BITable)BOrd.make((String)alarmQuery).get((BObject)this);
            TableCursor c = coll.cursor();
            while (c.next()) {
                BAlarmRecord record = (BAlarmRecord)c.get();
                BAbsTime startTime = (BAbsTime)record.getAlarmData().get("OnCallStartTime");
                BAbsTime endTime = null;
                if (startTime != null) {
                    endTime = startTime.add(this.getEscalationDelay());
                }
                if (endTime != null && (endTime.equals((Object)BAbsTime.now()) || endTime.isAfter(BAbsTime.now()))) {
                    BRelTime remaining = BAbsTime.now().delta(endTime);
                    out.w((Object)"<tr>");
                    out.td((Object)record.getAlarmData().gets("OnCallList", ""));
                    out.td((Object)record.getAlarmData().gets("OnCallContact", ""));
                    out.td((Object)String.valueOf(record.getAlarmData().geti("OnCallListPriority", -1)));
                    out.td((Object)startTime.toTimeString(null));
                    out.td((Object)endTime.toTimeString(null));
                    out.td((Object)remaining);
                    out.td((Object)record.getSource());
                    out.td((Object)record.getSourceState());
                    out.td((Object)record.getUuid());
                    out.w((Object)"</tr>\n");
                    continue;
                }
                out.w((Object)"<tr>");
                out.td((Object)record.getAlarmData().gets("OnCallList", ""));
                out.td((Object)record.getAlarmData().gets("OnCallContact", ""));
                out.td((Object)String.valueOf(record.getAlarmData().geti("OnCallListPriority", -1)));
                out.td((Object)"Expired");
                out.td((Object)"Expired");
                out.td((Object)"Expired");
                out.td((Object)record.getSource());
                out.td((Object)record.getSourceState());
                out.td((Object)record.getUuid());
                out.w((Object)"</tr>\n");
            }
            out.endTable();
            out.w((Object)"<br />");
        }
        super.spy(out);
    }
}

