/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BHxChangePassword
extends BHxView {
    public static final BHxChangePassword INSTANCE = new BHxChangePassword();
    public static final Type TYPE = Sys.loadType(BHxChangePassword.class);
    private SmartCommand save = new Save(this);
    private SmartCommand login;
    protected static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BHxChangePassword.class).getModuleName());

    public Type getType() {
        return TYPE;
    }

    public BHxChangePassword() {
        this.registerEvent((Event)this.save);
        this.login = new Login(this);
        this.registerEvent((Event)this.login);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet("module://smartTableHx/rc/smartTable.css");
        op.addJavaScript("module://smartTableHx/rc/smartTable.js");
        op.addJavaScript("module://web/com/tridium/web/rc/loginN4.js");
        HtmlWriter out = op.getHtmlWriter();
        op.addHeadTag("<script type='text/javascript' src='/login/core/auth.min.js'></script>");
        SmartCommand command = BHxChangePassword.isDigest(op) ? this.save : this.login;
        HxTabUtil.writeHeader((String)lex.getText("changePassword"), (SmartCommand[])new SmartCommand[]{this.save}, (HxOp)op);
        HxTabUtil.getSpacerDiv((HxOp)op);
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("user"), (HtmlWriter)out, (HxOp)op);
        out.safe((Object)op.getUser().getUsername());
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("currentPassword"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='password' size='16' name='currentPassword'");
        out.attr("autocomplete", "off");
        out.w((Object)">");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("newPassword"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='password' size='16' name='newPassword'");
        out.attr("autocomplete", "off");
        out.w((Object)">");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("confirmNewPassword"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='password' size='16' name='confirmNewPassword'");
        out.attr("autocomplete", "off");
        out.w((Object)">");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public static boolean isDigest(HxOp op) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        return userService.getAuthenticationSchemeForUser(op.getUser()) instanceof BDigestAuthenticationScheme;
    }

    private class Login
    extends SaveCommand {
        public Login(BHxView view) {
            super(view);
        }

        public boolean registerOnInputs() {
            return false;
        }

        public void onHandle(HxOp op) throws Exception {
            String old = op.getFormValue("currentPassword");
            String newA = op.getFormValue("newPassword");
            String newB = op.getFormValue("confirmNewPassword");
            String hash = newA;
            BUser user = op.getUser();
            if (!((BPasswordCache)user.getAuthenticator()).validate(old)) {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception("The current password was incorrect.")).open(op);
            } else if (!newA.equals(newB)) {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception("The new passwords do not match.")).open(op);
            } else {
                BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                BAuthenticationScheme authenticationScheme = userService.getAuthenticationSchemeForUser(user);
                if (authenticationScheme instanceof BPasswordAuthenticationScheme) {
                    try {
                        ((BPasswordAuthenticationScheme)authenticationScheme).checkPassword(newA);
                    }
                    catch (Exception e) {
                        new ErrorDialog("Error", (Command)this, (Throwable)e).open(op);
                        return;
                    }
                }
                ((BPasswordCache)user.getAuthenticator()).setPassword(BPassword.make((String)newA));
                new ErrorDialog.SuccessDialog("Success", (Command)this, "Password changed.", null).open(op);
                SmartCommand.setFormValue((String)op.scope("currentPassword"), (Object)"", (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("newPassword"), (Object)"", (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("confirmNewPassword"), (Object)"", (HxOp)op);
            }
        }
    }

    private class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public boolean registerOnInputs() {
            return true;
        }

        public void onHandle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)SmartCommand.getInvokeCode((Command)BHxChangePassword.this.login, (String)"'", (HxOp)op));
        }
    }
}

