/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.query.consolidated;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BStringFilter;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.PasswordUtil;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQuery;
import com.tridiumx.entsec.securityUtil.query.consolidated.ConsolidatedTableCursor;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import com.tridiumx.entsecHx.securityUtilHx.RedirectCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.PasswordEntryCommand;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.query.BQuery;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxConsolidatedQueryView
extends BHxQueryTableView {
    public static final BHxConsolidatedQueryView INSTANCE = new BHxConsolidatedQueryView();
    public static final Type TYPE = Sys.loadType(BHxConsolidatedQueryView.class);
    private SmartCommand passwordEntryCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxConsolidatedQueryView() {
        this.hyperlinkCommand = new StationHyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.hyperlinkCommand);
        this.passwordEntryCommand = new PasswordEntryCommand((BHxView)this);
        this.registerEvent((Event)this.passwordEntryCommand);
    }

    public int getMaxResultSize(Context cx) {
        return BActivityMonitor.MAX_RESULT_SIZE;
    }

    public int getMaxPageSize(Context cx) {
        return BActivityMonitor.MAX_RESULT_SIZE;
    }

    public boolean requiresPassword(HxOp op) {
        return PasswordUtil.requiresPasswordEntryForSubordinates((HxOp)op);
    }

    @Override
    public void loadTable(HxOp op) throws Exception {
        FinishTableThread finishTableThread = this.makeTableThread(false, op);
        if (finishTableThread == null) {
            return;
        }
        if (PasswordUtil.requiresPasswordEntryForSubordinates((HxOp)op)) {
            op.addOnload(this.passwordEntryCommand.getInvokeCode(op));
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("smartTable.pause($$(" + quote + op.scope("loading") + quote + "));");
        } else if (this.requiresPrefiltering(op)) {
            op.addOnload(this.filterCommand.getInvokeCode(op));
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("smartTable.pause($$(" + quote + op.scope("loading") + quote + "));");
        } else {
            op.addOnload(this.finishTableCommand.getInvokeCode(op));
        }
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BQuery query = super.getQuery(op);
        QueryUtil.reorderColumns((BQuery)query);
        return query;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.columnsCommand, this.filterCommand, this.hyperlinkCommand, this.refreshCommand, this.reportCommand, this.exportCommand};
    }

    @Override
    protected BITable getCollection(BOrd baseOrd, BQuery query, HxOp op) {
        BIBqlFilter filter;
        BFilterEntry entry;
        BQueryTableOptions options = (BQueryTableOptions)this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
        BFilterSet filterSet = options.getFilterSet(query);
        BStringFilter stationFilter = null;
        if (filterSet != null && (entry = (BFilterEntry)filterSet.get("stationName")) != null && entry.getActive() && (filter = entry.toFilter()) instanceof BStringFilter) {
            stationFilter = (BStringFilter)filter;
        }
        return ((BConsolidatedQuery)op.get()).getCollection(stationFilter, baseOrd, query, options.getSortColumnIndex(query), options.getSortColumnAsc(query), (Context)op);
    }

    @Override
    public String getRowKey(Type rowType, TableCursor cursor, HxOp op) {
        StringBuffer sb = new StringBuffer();
        sb.append(SlotPath.escape((String)((ConsolidatedTableCursor)cursor).getString(cursor.getTable().getColumns().get("entsec:ConsolidatedColumnsProvider.getStationName()")).toString()));
        sb.append(";").append(super.getRowKey(rowType, cursor, op));
        return sb.toString();
    }

    public class StationHyperlinkCommand
    extends RedirectCommand {
        public StationHyperlinkCommand(BHxView view) {
            super(view);
        }

        @Override
        public boolean isDefaultAction() {
            return true;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        @Override
        public String getPath(HxOp op) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList == null || selectionList.length < 1) {
                return null;
            }
            String rowId = BHxSmartTableView.unscopeId((String)selectionList[0]);
            int idx = rowId.indexOf(59);
            String slotPath = rowId.substring(idx + 1, rowId.length());
            return "/ord?station:|" + slotPath;
        }

        @Override
        public String getStationName(HxOp op) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList == null || selectionList.length < 1) {
                return null;
            }
            String rowId = BHxSmartTableView.unscopeId((String)selectionList[0]);
            int idx = rowId.indexOf(59);
            return SlotPath.unescape((String)rowId.substring(0, idx));
        }

        @Override
        public String getHostName(HxOp op) {
            String stationName = this.getStationName(op);
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
            return station.getRemoteHost().getHostname();
        }
    }
}

