/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.graphics;

import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.BImageFileTable;
import com.tridiumx.entsecHx.securityUtilHx.graphics.BHxImageFileView;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.types.image.BIImageFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BHxImageFileTableView
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxImageFileTableView.class);
    public static final BHxImageFileTableView INSTANCE = new BHxImageFileTableView();
    public static final Type TYPE = Sys.loadType(BHxImageFileTableView.class);
    protected SmartCommand addCommand;
    protected SmartCommand hyperlinkCommand = new HyperlinkCommand((BHxView)this);
    protected SmartCommand deleteCommand;
    protected SmartCommand renameCommand;

    public Type getType() {
        return TYPE;
    }

    public BHxImageFileTableView() {
        this.registerEvent((Event)this.hyperlinkCommand);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
        this.renameCommand = new RenameCommand((BHxView)this);
        this.registerEvent((Event)this.renameCommand);
        this.addCommand = new AddCommand((BHxView)this);
        this.registerEvent((Event)this.addCommand);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.hyperlinkCommand, this.renameCommand, this.deleteCommand, this.exportCommand};
    }

    public BIFile getFile(HxOp op) {
        BImageFileTable fileTable = new BImageFileTable();
        return (BIFile)fileTable.getBase().get();
    }

    public boolean supportsPagination(HxOp op) {
        return true;
    }

    public int minimumPageSize(HxOp op) {
        return 10;
    }

    public int defaultPageSize(HxOp op) {
        return 10;
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("imagePreview"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("fileName"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("size"));
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TableContents t = new TableContents(op.scope("records"));
        t.columns.td.add(new TableContents.Td(lex.getText("imagePreview")));
        t.columns.td.add(new TableContents.Td(lex.getText("timestamp")));
        t.columns.td.add(new TableContents.Td(lex.getText("size")));
        t.writeSafe = false;
        t.iconHeight = 32;
        BIFile file = this.getFile(op);
        this.writeImages(file, t, op);
        return t;
    }

    public void writeImages(BIFile file, TableContents contents, HxOp op) {
        BINavNode[] children = file.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            BIFile child = (BIFile)children[i];
            if (child.isDirectory()) {
                this.writeImages(child, contents, op);
                continue;
            }
            if (!(child instanceof BIImageFile)) continue;
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = child.getFilePath().toString();
            tr.td.add(new TableContents.Td(""));
            tr.td.add(new TableContents.Td(child.getFilePath().toString()));
            tr.td.add(new TableContents.Td("" + child.getSize() / 1000L + "k"));
            BImage image = BImage.make((BOrd)BOrd.make((String)child.getFilePath().toString()));
            tr.icons = new BImage[]{image};
            contents.tr.add(tr);
        }
    }

    public static class DeleteCommand
    extends SmartCommand {
        private ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

        public DeleteCommand(BHxView view) {
            super(view, smartTableHxLex);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            for (int i = 0; i < selectionList.length; ++i) {
                BOrd ord = BOrd.make((String)selectionList[i]);
                BIFile file = (BIFile)ord.get();
                file.delete();
            }
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class RenameCommand
    extends SmartCommand {
        protected RenameCommandDialog dlg = new RenameCommandDialog((Command)this, this.getDisplayName(null));

        public RenameCommand(BHxView view) {
            super(view, smartTableHxLex);
        }

        public String getName(HxOp op) {
            return "rename";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList.length == 1) {
                BOrd ord = BOrd.make((String)selectionList[0]);
                BIFile file = (BIFile)ord.get();
                Tab tab = this.getTab(op);
                String newName = tab.save().toString();
                File f = BFileSystem.INSTANCE.pathToLocalFile(file.getFilePath());
                File parent = f.getParentFile();
                FileUtil.move((File)f, (File)new File(parent, newName));
                ((BHxSmartTableView)this.getView()).reloadTable(op);
            }
        }

        public Tab getTab(HxOp op) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)selectionList[0]);
            BIFile file = (BIFile)ord.get();
            String name = file.getFileName();
            BHxStringFE fe = BHxStringFE.INSTANCE;
            HxOp fieldOp = op.make("rename", (BObject)BString.make((String)name), null);
            Tab tab = new Tab((BHxView)fe, "", fieldOp);
            return tab;
        }

        protected class RenameCommandDialog
        extends DynamicDialog {
            RenameCommandDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                RenameCommand.this.getTab(op).write();
            }
        }
    }

    public static class HyperlinkCommand
    extends SmartCommand {
        public HyperlinkCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList.length == 1) {
                BOrd ord = BOrd.make((String)selectionList[0]);
                op.getRequest().getSession().setAttribute("uploadedImage", (Object)ord);
                this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxImageFileView.TYPE))));
            }
        }
    }

    public static class AddCommand
    extends SmartCommand {
        public AddCommand(BHxView view) {
            super(view, smartTableHxLex);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxImageFileView.TYPE))));
        }
    }
}

