/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.fieldeditors;

import com.tridium.hx.fieldeditors.BHxPasswordFE;
import com.tridium.web.WebUtil;
import com.tridiumx.entsec.securityUtil.ui.BPinFE;
import java.security.AccessController;
import javax.baja.hx.HxOp;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;

public class BHxPinFE
extends BHxPasswordFE {
    public static final BHxPinFE INSTANCE = new BHxPinFE();
    public static final Type TYPE = Sys.loadType(BHxPinFE.class);
    static final Lexicon lex = Lexicon.make(BPinFE.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxPinFE() {
    }

    public void write(HxOp op) throws Exception {
        boolean readOnly = !WebUtil.isPasswordChangeAllowed((HttpServletRequest)op.getRequest());
        this.write(lex.getText("user.pinNumberOnly"), lex.getText("user.confirmPin"), op, readOnly);
    }

    public BObject save(HxOp op) throws Exception {
        BPassword password = (BPassword)super.save(op);
        if (password.equals((Object)op.get())) {
            return op.get();
        }
        String value = AccessController.doPrivileged(() -> ((BPassword)password).getValue());
        BFacets facets = op.getFacets();
        if (value.length() > 0) {
            int maxWidth;
            String s = value;
            int maxUiWidth = facets.geti("uiWidth", Integer.MAX_VALUE);
            if (s.length() > maxUiWidth) {
                throw new IllegalStateException("Length of PIN too long ( " + s.length() + " > " + maxUiWidth + " )");
            }
            int width = password.encodeToString().length();
            if (width > (maxWidth = facets.geti("width", Integer.MAX_VALUE))) {
                throw new IllegalStateException("Length of encoded PIN too long for database ( " + width + " > " + maxWidth + " )");
            }
            try {
                long l = Long.parseLong(value);
                if (l < 0L) {
                    throw new IllegalStateException("PIN must be positive");
                }
                if (l == 0L && !facets.getb("allowZero", false)) {
                    throw new LocalizableException(lex, "user.pinCannotBeZero");
                }
            }
            catch (NumberFormatException e) {
                throw new LocalizableException(lex, "user.pinMustBeNumber");
            }
        }
        return password;
    }
}

