/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.fieldeditors;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BHxAlarmInstructionsManager;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class AlarmInstructionsDialog
extends DynamicDialog {
    BHxView view;
    AddCommand add;
    EditCommand edit;
    DeleteCommand delete;
    MoveCommand moveUp;
    MoveCommand moveDown;
    BAlarmInstructions inst = null;
    boolean isMaster = false;
    protected static Lexicon lex = Lexicon.make(AlarmInstructionsDialog.class);

    public AlarmInstructionsDialog(String title, Command handler, BHxView view) {
        super(title, handler);
        this.isMaster = handler instanceof BHxAlarmInstructionsManager.MasterInstructionsCommand;
        this.view = view;
        this.add = new AddCommand(view);
        view.registerEvent((Event)this.add);
        this.edit = new EditCommand(view);
        view.registerEvent((Event)this.edit);
        this.delete = new DeleteCommand(view);
        view.registerEvent((Event)this.delete);
        this.moveUp = new MoveCommand(view, true);
        view.registerEvent((Event)this.moveUp);
        this.moveDown = new MoveCommand(view, false);
        view.registerEvent((Event)this.moveDown);
    }

    public void open(HxOp op, BAlarmInstructions initialValue) throws Exception {
        op.addJavaScript("module://entsecHx/rc/securityUtilHx/select.js");
        op.addJavaScript("module://smartTableHx/rc/smartTable.js");
        this.inst = initialValue;
        super.open(op);
    }

    public void open(HxOp op) throws Exception {
        this.inst = null;
        super.open(op);
    }

    public boolean process(HxOp op) throws Exception {
        if (this.view.process(op = op.make("dialog", (OrdTarget)op))) {
            return true;
        }
        return super.process(op);
    }

    protected void writeContent(HxOp op) throws Exception {
        HxOp originalOp = op;
        op = op.make("dialog", (OrdTarget)originalOp);
        String value = null;
        if (this.inst == null) {
            value = originalOp.getFormValue("value");
            this.inst = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
        } else {
            value = SlotPath.escape((String)this.inst.encodeToString());
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table>");
        out.w((Object)"<tr>");
        out.w((Object)"<td width='100%'>");
        out.w((Object)("<select size='12' name='" + op.scope("instructions") + "' id='" + op.scope("instructions") + "'"));
        HxTabUtil.selectMinWidthFix((int)300, (HtmlWriter)out, (HxOp)op);
        out.w((Object)">");
        for (int i = 0; i < this.inst.size(); ++i) {
            BFormat f = this.inst.get(i);
            String text = HxUtil.escapeJsStringLiteral((String)f.format((Object)this.view, (Context)op));
            out.w((Object)("<option value='" + i + "' title='")).safe((Object)text).w((Object)"'>");
            out.safe((Object)text);
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        BHxSmartTableView.writeFormValue((String)"instructions.newValue", (String)value, (HxOp)op);
        out.w((Object)"<td>");
        out.w((Object)"<table>");
        SmartCommand[] commands = new SmartCommand[]{this.add, this.edit, this.delete, this.moveUp, this.moveDown};
        for (int i = 0; i < commands.length; ++i) {
            out.w((Object)"<tr><td>");
            out.w((Object)"<table class='smartTableButtonNormal' width='100%'> ");
            out.w((Object)"<tr width='100%' ");
            out.attr("class", "smartTableButtonBorders");
            out.attr("id", op.scope(commands[i].getName(op)));
            out.attr("name", op.scope(commands[i].getName(op)));
            out.w((Object)" >");
            out.w((Object)"<td width='100%' class='smartTableButton'");
            out.attr(" id", op.scope(commands[i].getEnablePolicy().getTag()));
            out.attr(" name", op.scope(commands[i].getEnablePolicy().getTag()));
            out.w((Object)" onclick='").w((Object)commands[i].getInvokeCode(op)).w((Object)"'>");
            if (commands[i].getIcon(op) != null) {
                HxUtil.makeImage((BImage)commands[i].getIcon(op), (HxOp)op);
                out.w((Object)" ");
            }
            out.safe((Object)commands[i].getDisplayName(op));
            out.w((Object)"</td> ");
            out.w((Object)"</tr> ");
            out.w((Object)"</table> ");
            out.w((Object)"</tr></td>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    public BAlarmInstructions save(HxOp op) throws Exception {
        op = op.make("dialog", (OrdTarget)op);
        String value = op.getFormValue("instructions.newValue");
        BAlarmInstructions instr = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
        return instr;
    }

    public static class MoveCommand
    extends SmartCommand {
        boolean up = true;

        public MoveCommand(BHxView view, boolean up) {
            super(view);
            this.up = up;
        }

        public String getName(HxOp op) {
            if (this.up) {
                return "moveUp";
            }
            return "moveDown";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("instructions.newValue");
            BAlarmInstructions inst = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
            int id = -1;
            int swapId = -1;
            try {
                id = Integer.parseInt(op.getFormValue("instructions"));
            }
            catch (Exception e) {
                return;
            }
            if (this.up && id <= 0) {
                return;
            }
            if (!this.up && id >= inst.size() - 1) {
                return;
            }
            BFormat[] arr = inst.toArray();
            BFormat val = arr[id];
            swapId = this.up ? id - 1 : id + 1;
            BFormat swapVal = (BFormat)arr[swapId].newCopy();
            arr[swapId] = val;
            arr[id] = swapVal;
            inst = BAlarmInstructions.make((BFormat[])arr);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("select.swap('" + op.scope("instructions") + "','" + id + "','" + swapId + "');"));
            out.w((Object)("document.getElementById('" + op.scope("instructions") + ".newValue').value='" + SlotPath.escape((String)inst.encodeToString()) + "';"));
        }
    }

    public static class DeleteCommand
    extends SmartCommand {
        public DeleteCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("instructions.newValue");
            BAlarmInstructions inst = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
            int id = -1;
            try {
                id = Integer.parseInt(op.getFormValue("instructions"));
            }
            catch (Exception e) {
                return;
            }
            inst = BAlarmInstructions.remove((BAlarmInstructions)inst, (int)id);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("select.removeFromSelect('" + op.scope("instructions") + "','" + id + "');"));
            out.w((Object)("document.getElementById('" + op.scope("instructions") + ".newValue').value='" + SlotPath.escape((String)inst.encodeToString()) + "';"));
        }
    }

    public class EditCommand
    extends SmartCommand {
        InstructionDialog innerDialog;

        public EditCommand(BHxView view) {
            super(view);
            this.innerDialog = new InstructionDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("instructions.newValue");
            BAlarmInstructions inst = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
            int id = -1;
            try {
                id = Integer.parseInt(op.getFormValue("instructions"));
            }
            catch (Exception e) {
                return;
            }
            BFormat editValue = inst.get(id);
            if (!this.innerDialog.isSubmit(op)) {
                this.innerDialog.open(op, editValue.getFormat());
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            String instType = op.getFormValue("instType");
            String dialogValue = "";
            dialogValue = instType == null || !instType.equals("master") ? op.getFormValue("newInstruction") : op.getFormValue("newMasterInstruction");
            if (dialogValue == null || dialogValue.length() == 0) {
                out.w((Object)("select.removeFromSelect('" + op.scope("instructions") + "','" + id + "');"));
                out.w((Object)("document.getElementById('" + op.scope("instructions") + ".newValue').value='" + SlotPath.escape((String)inst.encodeToString()) + "';"));
                return;
            }
            BFormat[] arr = inst.toArray();
            arr[id] = BFormat.make((String)dialogValue);
            inst = BAlarmInstructions.make((BFormat[])arr);
            out.w((Object)("select.updateSelect('" + op.scope("instructions") + "','" + id + "','" + HxTabUtil.safe((String)dialogValue) + "');"));
            out.w((Object)("document.getElementById('" + op.scope("instructions") + ".newValue').value='" + SlotPath.escape((String)inst.encodeToString()) + "';"));
        }
    }

    public class AddCommand
    extends SmartCommand {
        InstructionDialog innerDialog;

        public AddCommand(BHxView view) {
            super(view);
            this.innerDialog = new InstructionDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.innerDialog.isSubmit(op)) {
                this.innerDialog.open(op);
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            String instType = op.getFormValue("instType");
            String dialogValue = "";
            dialogValue = instType == null || !instType.equals("master") ? op.getFormValue("newInstruction") : op.getFormValue("newMasterInstruction");
            if (dialogValue == null || dialogValue.length() == 0) {
                return;
            }
            String value = op.getFormValue("instructions.newValue");
            BAlarmInstructions inst = (BAlarmInstructions)BAlarmInstructions.NULL.decodeFromString(SlotPath.unescape((String)value));
            inst = BAlarmInstructions.add((BAlarmInstructions)inst, (BFormat)BFormat.make((String)dialogValue));
            out.w((Object)("select.addToSelect('" + op.scope("instructions") + "','" + (inst.size() - 1) + "','" + HxTabUtil.safe((String)dialogValue) + "');"));
            out.w((Object)("document.getElementById('" + op.scope("instructions") + ".newValue').value='" + SlotPath.escape((String)inst.encodeToString()) + "';"));
        }
    }

    public class InstructionDialog
    extends Dialog {
        String initValue;

        public InstructionDialog(String title, Command handler) {
            super(title, handler);
            this.initValue = "";
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand("submitLevel2"), new Dialog.Cancel((Dialog)this)};
        }

        public void open(HxOp op, String initValue) throws Exception {
            this.initValue = initValue;
            super.open(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            BAlarmService alarmService;
            OrdTarget target = op.getBaseOrdTarget();
            while (!(target.get() instanceof BComponent)) {
                target = target.getBaseOrdTarget();
            }
            while (((BComponent)target.get()).getSession() == null) {
                target = target.getBaseOrdTarget();
                while (!(target.get() instanceof BComponent)) {
                    target = target.getBaseOrdTarget();
                }
            }
            if (((BComponent)target.get()).getSession() instanceof BLocalHost) {
                alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            } else {
                BFoxSession session = (BFoxSession)((BComponent)target.get()).getSession();
                alarmService = (BAlarmService)session.getService(BAlarmService.TYPE);
            }
            BAlarmInstructions master = alarmService.getMasterAlarmInstructions();
            HtmlWriter out = op.getHtmlWriter();
            if (master.size() > 0 && !AlarmInstructionsDialog.this.isMaster) {
                out.w((Object)("<input type='radio' name='" + op.scope("instType") + "' id='" + op.scope("instType1") + "' id='defaultInstType' value='default' "));
                if (this.initValue.length() > 0) {
                    out.w((Object)" checked='true'");
                }
                out.w((Object)"/>");
            }
            out.w((Object)("<input type='text' size='40' name='" + op.scope("newInstruction") + "' id='" + op.scope("newInstruction") + "' value='" + HxTabUtil.safe((String)this.initValue) + "' "));
            if (master.size() > 0 && !AlarmInstructionsDialog.this.isMaster) {
                out.w((Object)(" onclick='smartTable.checkInput(&quot;" + op.scope("instType1") + "&quot;); '"));
            }
            out.w((Object)"/>");
            if (master.size() > 0 && !AlarmInstructionsDialog.this.isMaster) {
                out.w((Object)"<br /><center>").safe((Object)lex.getText("or")).w((Object)"</center><br />");
                out.w((Object)"<center>").safe((Object)lex.getText("addFromMasterList")).w((Object)"</center>");
                out.w((Object)("<input type='radio' name='" + op.scope("instType") + "' id='" + op.scope("instType2") + "' value='master' "));
                if (this.initValue.length() == 0) {
                    out.w((Object)" checked='true'");
                }
                out.w((Object)"/>");
                out.w((Object)("<select name='" + op.scope("newMasterInstruction") + "' id='" + op.scope("newInstruction") + "'"));
                HxTabUtil.selectMinWidthFix((int)220, (HtmlWriter)out, (HxOp)op);
                out.w((Object)(" onclick='smartTable.checkInput(&quot;" + op.scope("instType2") + "&quot;); '"));
                out.w((Object)">");
                for (int i = 0; i < master.size(); ++i) {
                    BFormat format = master.get(i);
                    out.w((Object)("<option value='" + format + "' title='")).safe((Object)format.toString()).w((Object)"' ");
                    if (format.toString().equals(this.initValue)) {
                        out.w((Object)"selected='selected'");
                    }
                    out.w((Object)">").safe((Object)format.toString()).w((Object)"</option>");
                }
                out.w((Object)"</select>");
            }
        }
    }
}

