/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.workbench.auth.BCredentialsEditor;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxPasswordEntryFE;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BHxCredentialStoreFE
extends BHxFieldEditor {
    public static final BHxCredentialStoreFE INSTANCE = new BHxCredentialStoreFE();
    public static final Type TYPE = Sys.loadType(BHxCredentialStoreFE.class);
    private List<BIUserCredentials> credentialList;
    private static final String CRED_EDIT = "cred";
    private static final String CRED_EDIT_LINK = "credModifiedLink";

    public Type getType() {
        return TYPE;
    }

    private Tab getPasswordTab(HxOp op, BPassword password) {
        HxOp fieldOp = op.make(BUsernameAndPassword.password.getName(), (BObject)password, BFacets.make((String)"hidePasswordLength", (boolean)false));
        return new Tab((BHxView)BHxPasswordEntryFE.INSTANCE, fieldOp, op);
    }

    private Tab getUsernameTab(HxOp op, String username) {
        HxOp fieldOp = op.make(BUsernameAndPassword.username.getName(), (BObject)BString.make((String)username), BFacets.make((String)"fieldWidth", (int)20));
        return new Tab((BHxView)BHxStringFE.INSTANCE, fieldOp, op);
    }

    public void write(HxOp op) throws Exception {
        BClientCredentials clientCredentials = (BClientCredentials)op.get();
        HtmlWriter out = op.getHtmlWriter();
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)"", (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<select ");
        out.attr("name", op.scope("value"));
        out.attr("id", op.scope("value"));
        out.attr("onchange", "hx.setFormValue('" + op.scope("disabledValue") + "', this.value);");
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        AgentList agentList = clientCredentials.getAgents();
        agentList = agentList.filter(AgentFilter.is((Type)BIUserCredentials.TYPE));
        Type credentialType = clientCredentials.getClientCredentials().getType();
        BTypeSpec credentialTypeSpec = credentialType.getTypeSpec();
        String currentCredentialName = credentialTypeSpec.getTypeName();
        this.credentialList = new ArrayList<BIUserCredentials>();
        for (AgentInfo info : agentList.list()) {
            AgentList credAgentList = info.getAgentType().getAgents().filter(AgentFilter.is((Type)BCredentialsEditor.TYPE));
            if (credAgentList.size() == 0) continue;
            BIUserCredentials cred = (BIUserCredentials)info.getInstance();
            this.credentialList.add(cred);
            String credentialTypeName = cred.getType().getTypeSpec().getTypeName();
            out.w((Object)"<option ").attr("value", credentialTypeName);
            if (credentialTypeName.equals(currentCredentialName)) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)credentialTypeName);
            out.w((Object)"</option>");
        }
        out.w((Object)"</select> ");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        if (credentialType.is(BUsernameAndPassword.TYPE)) {
            BUsernameAndPassword usernameAndPassword = (BUsernameAndPassword)clientCredentials.getCredentials();
            HxTabUtil.startRow((String)BUsernameAndPassword.username.getDefaultDisplayName((Context)op), (HtmlWriter)out, (HxOp)op);
            this.getUsernameTab(op, usernameAndPassword.getUsername()).write();
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)BUsernameAndPassword.password.getDefaultDisplayName((Context)op), (HtmlWriter)out, (HxOp)op);
            this.getPasswordTab(op, usernameAndPassword.getPassword()).write();
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        }
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public BObject save(HxOp op) throws Exception {
        BClientCredentials clientCredentials = (BClientCredentials)op.get();
        BUsernameAndPassword usernameAndPassword = (BUsernameAndPassword)clientCredentials.getCredentials();
        String username = this.getUsernameTab(op, usernameAndPassword.getUsername()).save().toString();
        BPassword password = (BPassword)this.getPasswordTab(op, usernameAndPassword.getPassword()).save();
        if (username.equals(usernameAndPassword.getUsername()) && password.validate(usernameAndPassword.getPassword())) {
            return clientCredentials;
        }
        BClientCredentials result = new BClientCredentials();
        result.setCredentials((BIUserCredentials)new BUsernameAndPassword(username, password));
        return result;
    }
}

