/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.bacnet;

import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import java.util.StringTokenizer;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBdtManager
extends BHxSmartTableView {
    public static final BBdtManager INSTANCE = new BBdtManager();
    public static final Type TYPE = Sys.loadType(BBdtManager.class);
    private AddCommand addCommand = new AddCommand((BHxView)this);
    private EditCommand editCommand;
    private DeleteCommand deleteCommand;

    protected BBdtManager() {
        this.registerEvent((Event)this.addCommand);
        this.editCommand = new EditCommand((BHxView)this);
        this.registerEvent((Event)this.editCommand);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
    }

    public String getPageTitle(HxOp op) {
        return op.getLexicon("entsecHx").getText("bdtManager.title");
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)op.getLexicon("entsecHx").getText("bdtManager.entryName"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)op.getLexicon("entsecHx").getText("bdtManager.ipAddress"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)op.getLexicon("entsecHx").getText("bdtManager.distributionMask"));
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp op) {
        TableContents table = new TableContents(op.scope("bdt"));
        table.columns.td.add(new TableContents.Td(op.getLexicon("entsecHx").getText("bdtManager.bacnetIpAddress")));
        BBroadcastDistributionTable bdt = (BBroadcastDistributionTable)op.get();
        SlotCursor c = bdt.getProperties();
        while (c.next(BBdtEntry.class)) {
            BBdtEntry entry = (BBdtEntry)c.get();
            String rowId = c.property().getName();
            TableContents.Tr row = new TableContents.Tr();
            row.id = rowId;
            row.td.add(new TableContents.Td(entry.getName()));
            row.td.add(new TableContents.Td(entry.getBacnetIPAddress()));
            row.td.add(new TableContents.Td(entry.getBroadcastDistributionMask()));
            table.tr.add(row);
        }
        return table;
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.editCommand, this.deleteCommand, this.exportCommand};
    }

    public Type getType() {
        return TYPE;
    }

    public class DeleteCommand
    extends SmartCommand {
        private ConfirmDialog dlg;

        public DeleteCommand(BHxView owner) {
            super(owner);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "bdtManager.delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BBroadcastDistributionTable bdt = (BBroadcastDistributionTable)op.get();
            String selectionList = op.getFormValue("selectionList");
            if (selectionList == null) {
                return;
            }
            StringTokenizer t = new StringTokenizer(selectionList, "|");
            while (t.hasMoreTokens()) {
                String entry = t.nextToken();
                Property entryProp = bdt.getProperty(entry);
                if (entryProp.isFrozen()) continue;
                bdt.remove(entryProp, (Context)op);
            }
            BBdtManager.this.reloadTable(op);
        }
    }

    public class EditCommand
    extends SmartCommand {
        public EditCommand(BHxView owner) {
            super(owner);
        }

        public String getName(HxOp op) {
            return "bdtManager.edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String selectedEntry = op.getFormValue("selectionList");
            if (selectedEntry.indexOf(124) != -1) {
                return;
            }
            this.redirect(op, BOrd.make((String)("station:|" + ((BComponent)op.get()).getSlotPathOrd() + "|view:entsecHx:BdtEntryView?entryName=" + selectedEntry)));
        }
    }

    public class AddCommand
    extends SmartCommand {
        public AddCommand(BHxView owner) {
            super(owner);
        }

        public String getName(HxOp op) {
            return "bdtManager.add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            this.redirect(op, BOrd.make((String)("station:|" + ((BComponent)op.get()).getSlotPathOrd() + "|view:entsecHx:BdtEntryView")));
        }
    }
}

